/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.portal;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheLoader;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.event.api.EventListener;
import com.atlassian.gadgets.dashboard.Color;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.portal.FlushablePortletConfigurationStore;
import com.atlassian.jira.portal.PortletConfiguration;
import com.atlassian.jira.portal.PortletConfigurationImpl;
import com.atlassian.jira.portal.PortletConfigurationStore;
import com.atlassian.jira.util.collect.EnclosedIterable;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.util.map.CacheObject;
import com.atlassian.plugin.ModuleCompleteKey;
import com.google.common.collect.ImmutableList;
import io.atlassian.fugue.Option;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;

@EventComponent
public class CachingPortletConfigurationStore
implements FlushablePortletConfigurationStore {
    private final PortletConfigurationStore delegateStore;
    private final Cache<Long, List<Long>> cacheByPageId;
    private final Cache<Long, CacheObject<PortletConfiguration>> cacheById;

    public CachingPortletConfigurationStore(PortletConfigurationStore delegateStore, CacheManager cacheManager) {
        Assertions.notNull((String)"delegateStore", (Object)delegateStore);
        this.delegateStore = delegateStore;
        this.cacheByPageId = cacheManager.getCache(CachingPortletConfigurationStore.class.getName() + ".cacheByPageId", (CacheLoader)new ByPageIdCacheLoader(), new CacheSettingsBuilder().expireAfterAccess(30L, TimeUnit.MINUTES).build());
        this.cacheById = cacheManager.getCache(CachingPortletConfigurationStore.class.getName() + ".cacheById", (CacheLoader)new ByIdCacheLoader(), new CacheSettingsBuilder().expireAfterAccess(30L, TimeUnit.MINUTES).build());
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.flush();
    }

    @Override
    public List<PortletConfiguration> getByPortalPage(Long portalPageId) {
        Assertions.notNull((String)"portalPageId", (Object)portalPageId);
        List configIds = (List)this.cacheByPageId.get((Object)portalPageId);
        ArrayList<PortletConfiguration> returnList = new ArrayList<PortletConfiguration>(configIds.size());
        for (Object element : configIds) {
            Long id = (Long)element;
            PortletConfiguration portletConfiguration = this.getByPortletId(id);
            if (portletConfiguration == null) continue;
            returnList.add(portletConfiguration);
        }
        return returnList;
    }

    @Override
    public PortletConfiguration getByPortletId(Long portletId) {
        Assertions.notNull((String)"portletId", (Object)portletId);
        CacheObject portletConfigurationCacheObject = (CacheObject)this.cacheById.get((Object)portletId);
        return portletConfigurationCacheObject != null ? this.copyConfiguration((PortletConfiguration)portletConfigurationCacheObject.getValue()) : null;
    }

    @Override
    public void delete(PortletConfiguration pc) {
        Assertions.notNull((String)"pc", (Object)pc);
        Assertions.notNull((String)"pc.id", (Object)pc.getId());
        try {
            this.delegateStore.delete(pc);
        }
        finally {
            this.cacheById.remove((Object)pc.getId());
            this.cacheByPageId.removeAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateGadgetPosition(Long gadgetId, int row, int column, Long dashboardId) {
        Assertions.notNull((String)"gadgetId", (Object)gadgetId);
        Assertions.notNull((String)"dashboardId", (Object)dashboardId);
        Long existingDashboardId = null;
        try {
            CacheObject cacheObject = (CacheObject)this.cacheById.get((Object)gadgetId);
            if (cacheObject != null && cacheObject.getValue() != null) {
                existingDashboardId = ((PortletConfiguration)cacheObject.getValue()).getDashboardPageId();
            } else {
                PortletConfiguration pc = this.delegateStore.getByPortletId(gadgetId);
                existingDashboardId = pc.getDashboardPageId();
            }
            this.delegateStore.updateGadgetPosition(gadgetId, row, column, dashboardId);
        }
        finally {
            this.cacheById.remove((Object)gadgetId);
            this.cacheByPageId.remove((Object)dashboardId);
            if (existingDashboardId != null) {
                this.cacheByPageId.remove((Object)existingDashboardId);
            }
        }
    }

    @Override
    public void updateGadgetColor(Long gadgetId, Color color) {
        Assertions.notNull((String)"gadgetId", (Object)gadgetId);
        Assertions.notNull((String)"color", (Object)color);
        try {
            this.delegateStore.updateGadgetColor(gadgetId, color);
        }
        finally {
            this.cacheById.remove((Object)gadgetId);
        }
    }

    @Override
    public void updateUserPrefs(Long gadgetId, Map<String, String> userPrefs) {
        Assertions.notNull((String)"gadgetId", (Object)gadgetId);
        Assertions.notNull((String)"userPrefs", userPrefs);
        try {
            this.delegateStore.updateUserPrefs(gadgetId, userPrefs);
        }
        finally {
            this.cacheById.remove((Object)gadgetId);
        }
    }

    @Override
    public void store(PortletConfiguration pc) {
        Assertions.notNull((String)"pc", (Object)pc);
        Assertions.notNull((String)"pc.id", (Object)pc.getId());
        try {
            this.delegateStore.store(pc);
        }
        finally {
            this.cacheById.remove((Object)pc.getId());
            this.cacheByPageId.removeAll();
        }
    }

    @Override
    public PortletConfiguration addGadget(Long pageId, Long portletConfigurationId, Integer column, Integer row, URI gadgetXml, Color color, Map<String, String> userPreferences) {
        return this.addDashboardItem(pageId, portletConfigurationId, column, row, (Option<URI>)Option.some((Object)gadgetXml), color, userPreferences, (Option<ModuleCompleteKey>)Option.none());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PortletConfiguration addDashboardItem(Long pageId, Long portletConfigurationId, Integer column, Integer row, Option<URI> openSocialSpecUri, Color color, Map<String, String> userPreferences, Option<ModuleCompleteKey> moduleKey) {
        Assertions.notNull((String)"pageId", (Object)pageId);
        Assertions.notNull((String)"column", (Object)column);
        Assertions.notNull((String)"row", (Object)row);
        Assertions.notNull((String)"userPreferences", userPreferences);
        Assertions.notNull((String)"color", (Object)color);
        PortletConfiguration returnConfig = null;
        try {
            returnConfig = this.delegateStore.addDashboardItem(pageId, portletConfigurationId, column, row, openSocialSpecUri, color, userPreferences, moduleKey);
        }
        finally {
            if (returnConfig != null) {
                this.cacheByPageId.remove((Object)returnConfig.getDashboardPageId());
            }
        }
        return this.copyConfiguration(returnConfig);
    }

    @Override
    public void flush() {
        this.cacheByPageId.removeAll();
        this.cacheById.removeAll();
    }

    @Override
    public EnclosedIterable<PortletConfiguration> getAllPortletConfigurations() {
        return this.delegateStore.getAllPortletConfigurations();
    }

    private PortletConfiguration copyConfiguration(PortletConfiguration portletConfiguration) {
        if (portletConfiguration != null) {
            return new PortletConfigurationImpl(portletConfiguration.getId(), portletConfiguration.getDashboardPageId(), portletConfiguration.getColumn(), portletConfiguration.getRow(), (Option<URI>)portletConfiguration.getOpenSocialSpecUri(), portletConfiguration.getColor(), portletConfiguration.getUserPrefs(), (Option<ModuleCompleteKey>)portletConfiguration.getCompleteModuleKey());
        }
        return null;
    }

    private class ByPageIdCacheLoader
    implements CacheLoader<Long, List<Long>> {
        private ByPageIdCacheLoader() {
        }

        @Nonnull
        public List<Long> load(@Nonnull Long portletPageId) {
            List<PortletConfiguration> configs = CachingPortletConfigurationStore.this.delegateStore.getByPortalPage(portletPageId);
            if (configs != null) {
                ArrayList<Long> ownedSearchRequestIds = new ArrayList<Long>(configs.size());
                for (PortletConfiguration config : configs) {
                    ownedSearchRequestIds.add(config.getId());
                }
                return ImmutableList.copyOf(ownedSearchRequestIds);
            }
            return ImmutableList.of();
        }
    }

    private class ByIdCacheLoader
    implements CacheLoader<Long, CacheObject<PortletConfiguration>> {
        private ByIdCacheLoader() {
        }

        @Nonnull
        public CacheObject<PortletConfiguration> load(@Nonnull Long portletId) {
            return CacheObject.wrap(CachingPortletConfigurationStore.this.delegateStore.getByPortletId(portletId));
        }
    }
}

