/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.portal;

import com.atlassian.jira.bc.portal.PortalPageService;
import com.atlassian.jira.portal.PortalPage;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserHistoryItem;
import com.atlassian.jira.user.UserHistoryManager;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.velocity.VelocityRequestContext;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.plugin.web.api.WebItem;
import com.atlassian.plugin.web.api.provider.WebItemProvider;
import com.atlassian.plugin.web.model.WebFragmentBuilder;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class FavouriteDashboardLinkFactory
implements WebItemProvider {
    private static final int MAX_LABEL_LENGTH = 30;
    private static final String ITEM_SECTION = "home_link/dashboard_link_main";
    private final PortalPageService portalPageService;
    private final VelocityRequestContextFactory velocityRequestContextFactory;
    private final I18nHelper.BeanFactory i18nFactory;
    private final UserHistoryManager userHistoryManager;

    public FavouriteDashboardLinkFactory(PortalPageService portalPageService, VelocityRequestContextFactory velocityRequestContextFactory, I18nHelper.BeanFactory i18nFactory, UserHistoryManager userHistoryManager) {
        this.portalPageService = portalPageService;
        this.velocityRequestContextFactory = velocityRequestContextFactory;
        this.i18nFactory = i18nFactory;
        this.userHistoryManager = userHistoryManager;
    }

    public Iterable<WebItem> getItems(Map<String, Object> context) {
        ApplicationUser user = (ApplicationUser)context.get("user");
        VelocityRequestContext requestContext = this.velocityRequestContextFactory.getJiraVelocityRequestContext();
        Collection portalPages = this.portalPageService.getFavouritePortalPages(user);
        String baseUrl = requestContext.getBaseUrl();
        I18nHelper i18n = this.i18nFactory.getInstance(user);
        ArrayList links = Lists.newArrayList();
        int weight = 10;
        if (portalPages == null || portalPages.isEmpty()) {
            links.add(new WebFragmentBuilder(weight += 10).id("dash_lnk_system").label(i18n.getText("menu.dashboard.view.system")).title(i18n.getText("menu.dashboard.view.system.title")).webItem(ITEM_SECTION).url(baseUrl + "/secure/Dashboard.jspa").build());
        } else {
            Long currentDash = this.getCurrentDashboard(user);
            for (PortalPage portalPage : portalPages) {
                String title;
                String style = null;
                Long pageId = portalPage.getId();
                String description = portalPage.getDescription();
                String name = portalPage.getName();
                Object shortName = name;
                if (((String)shortName).length() > 30) {
                    shortName = ((String)shortName).substring(0, 30) + "...";
                }
                String string = title = StringUtils.isBlank((CharSequence)description) ? name : i18n.getText("menu.dashboard.title", name, description);
                if (portalPages.size() > 1 && pageId.equals(currentDash)) {
                    style = "bolded";
                }
                links.add(new WebFragmentBuilder(weight += 10).id("dash_lnk_" + pageId).label((String)shortName).title(title).styleClass(style).webItem(ITEM_SECTION).url(baseUrl + "/secure/Dashboard.jspa?selectPageId=" + pageId).build());
            }
        }
        return links;
    }

    private Long getCurrentDashboard(ApplicationUser user) {
        List history = this.userHistoryManager.getHistory(UserHistoryItem.DASHBOARD, user);
        if (!history.isEmpty()) {
            return Long.valueOf(((UserHistoryItem)history.get(0)).getEntityId());
        }
        return null;
    }
}

