/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.project.archiving;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.jira.JiraFeatureFlagRegistrar;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectPropertiesManager;
import com.atlassian.jira.project.archiving.ArchivingLicenseCheck;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.DefaultUserManager;
import com.google.common.base.Preconditions;
import java.util.Date;
import java.util.Optional;
import javax.annotation.Nullable;

@ExperimentalApi
public class ArchivedProjectManager {
    public static final String IS_ARCHIVED_KEY = "jira.archiving.projects";
    private static final String ARCHIVED_DATE_KEY = "jira.archiving.projects.date";
    private static final String ARCHIVED_BY_KEY = "jira.archiving.projects.archived.by";
    @Deprecated
    private static final String ARCHIVED_TIMESTAMP_KEY = "jira.archiving.projects.timestamp";
    private final ProjectPropertiesManager projectPropertiesManager;
    private final ArchivingLicenseCheck archivingLicenseCheck;
    private final DefaultUserManager defaultUserManager;
    private final FeatureManager featureManager;

    public ArchivedProjectManager(ProjectPropertiesManager projectPropertiesManager, ArchivingLicenseCheck archivingLicenseCheck, DefaultUserManager defaultUserManager, FeatureManager featureManager) {
        this.projectPropertiesManager = projectPropertiesManager;
        this.archivingLicenseCheck = archivingLicenseCheck;
        this.defaultUserManager = defaultUserManager;
        this.featureManager = featureManager;
    }

    public boolean isProjectArchived(@Nullable Project project) {
        return project != null && this.projectPropertiesManager.getPropertySet(project).exists(IS_ARCHIVED_KEY) && this.isArchivingAllowed();
    }

    public boolean isArchivingAllowed() {
        return this.archivingLicenseCheck.isLicensedForProjectArchiving();
    }

    public boolean isIssueArchived(Issue issue) {
        return this.isProjectArchived(issue.getProjectObject());
    }

    public void markProjectAsArchived(Project project, ApplicationUser archivedBy) {
        Preconditions.checkState((!this.isProjectArchived(project) ? 1 : 0) != 0, (Object)(project + " is already archived"));
        this.projectPropertiesManager.getPropertySet(project).setBoolean(IS_ARCHIVED_KEY, true);
        if (archivedBy != null) {
            this.projectPropertiesManager.getPropertySet(project).setLong(ARCHIVED_BY_KEY, archivedBy.getId().longValue());
        }
        this.setArchivedDate(project);
        ComponentAccessor.getProjectManager().refresh();
    }

    private void setArchivedDate(Project project) {
        Date archivedDate = new Date();
        this.projectPropertiesManager.getPropertySet(project).setDate(ARCHIVED_DATE_KEY, archivedDate);
        if (!this.featureManager.isEnabled(JiraFeatureFlagRegistrar.BROWSE_ARCHIVED_PAGE)) {
            this.projectPropertiesManager.getPropertySet(project).setLong(ARCHIVED_TIMESTAMP_KEY, archivedDate.getTime());
        }
    }

    public void markProjectAsActive(Project project) {
        Preconditions.checkState((boolean)this.isProjectArchived(project), (Object)(project + " is not archived"));
        this.projectPropertiesManager.getPropertySet(project).remove(IS_ARCHIVED_KEY);
        this.projectPropertiesManager.getPropertySet(project).remove(ARCHIVED_BY_KEY);
        this.projectPropertiesManager.getPropertySet(project).remove(ARCHIVED_DATE_KEY);
        this.projectPropertiesManager.getPropertySet(project).remove(ARCHIVED_TIMESTAMP_KEY);
        ComponentAccessor.getProjectManager().refresh();
    }

    public Optional<ApplicationUser> getArchivedBy(Project project) {
        if (!this.isProjectArchived(project)) {
            return Optional.empty();
        }
        if (!this.projectPropertiesManager.getPropertySet(project).exists(ARCHIVED_BY_KEY)) {
            return Optional.empty();
        }
        return this.defaultUserManager.getUserById(this.projectPropertiesManager.getPropertySet(project).getLong(ARCHIVED_BY_KEY));
    }

    @Nullable
    public Long getArchivedTimestamp(Project project) {
        if (!this.isProjectArchived(project)) {
            return null;
        }
        if (this.featureManager.isEnabled(JiraFeatureFlagRegistrar.BROWSE_ARCHIVED_PAGE)) {
            return Optional.ofNullable(this.projectPropertiesManager.getPropertySet(project).getDate(ARCHIVED_DATE_KEY)).map(Date::getTime).orElse(null);
        }
        return this.projectPropertiesManager.getPropertySet(project).getLong(ARCHIVED_TIMESTAMP_KEY);
    }
}

