/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.project.template.descriptor;

import com.atlassian.jira.project.template.descriptor.PluginParseHelper;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.internal.module.Dom4jDelegatingElement;
import com.atlassian.plugin.module.Element;
import java.util.Optional;
import org.dom4j.Node;

public class DefaultPluginParseHelper
implements PluginParseHelper {
    private final Element element;
    private final String xpath;

    public DefaultPluginParseHelper(Element element, String xpath) {
        this.element = element;
        this.xpath = xpath;
    }

    @Override
    public PluginParseHelper element(String name) {
        return this.element(name, true);
    }

    @Override
    public Optional<PluginParseHelper> optElement(String name) {
        return Optional.ofNullable(this.element(name, false));
    }

    @Override
    public String attribute(String name) {
        return this.attribute(name, true);
    }

    @Override
    public String optAttribute(String name) {
        return this.attribute(name, false);
    }

    @Override
    public String text() {
        return this.element.getText();
    }

    @Override
    public Element rawElement() {
        return this.element;
    }

    private PluginParseHelper element(String name, boolean required) {
        String xpath = String.format("%s/%s", this.xpath, name);
        Node node = ((Dom4jDelegatingElement)this.element).getDelegate().selectSingleNode(xpath);
        if (node == null) {
            if (required) {
                throw new PluginParseException("Missing expected node: " + xpath);
            }
            return null;
        }
        if (node instanceof org.dom4j.Element) {
            org.dom4j.Element e = (org.dom4j.Element)node;
            return new DefaultPluginParseHelper((Element)new Dom4jDelegatingElement(e), xpath);
        }
        throw new PluginParseException(String.format("Got %s at %s when expecting an Element", node.getClass(), xpath));
    }

    private String attribute(String name, boolean required) {
        String attribute = this.element.attributeValue(name);
        if (attribute == null) {
            if (required) {
                throw new PluginParseException(String.format("Missing expected attribute %s at: %s", name, this.xpath));
            }
            return null;
        }
        return attribute;
    }
}

