/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.project.template.hook;

import com.atlassian.jira.project.template.hook.ConfigTemplate;
import com.atlassian.jira.project.template.hook.IssueTypeSchemeTemplate;
import com.atlassian.jira.project.template.hook.IssueTypeSchemeTemplateImpl;
import com.atlassian.jira.project.template.hook.IssueTypeScreenSchemeTemplate;
import com.atlassian.jira.project.template.hook.IssueTypeScreenSchemeTemplateImpl;
import com.atlassian.jira.project.template.hook.IssueTypeTemplate;
import com.atlassian.jira.project.template.hook.ResolutionTemplate;
import com.atlassian.jira.project.template.hook.ResolutionTemplateImpl;
import com.atlassian.jira.project.template.hook.ScreenSchemeTemplate;
import com.atlassian.jira.project.template.hook.WorkflowSchemeTemplate;
import com.atlassian.jira.project.template.hook.WorkflowSchemeTemplateImpl;
import com.atlassian.jira.project.template.hook.WorkflowTemplate;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ConfigTemplateImpl
implements ConfigTemplate {
    private final Optional<WorkflowSchemeTemplate> workflowSchemeTemplate;
    private final Optional<IssueTypeSchemeTemplate> issueTypeSchemeTemplate;
    private final Optional<IssueTypeScreenSchemeTemplate> issueTypeScreenSchemeTemplate;
    private final List<? extends ResolutionTemplate> resolutionTemplates;

    public ConfigTemplateImpl(@JsonProperty(value="workflow-scheme") WorkflowSchemeTemplateImpl workflowSchemeTemplate, @JsonProperty(value="issue-type-scheme") IssueTypeSchemeTemplateImpl issueTypeSchemeTemplate, @JsonProperty(value="issue-type-screen-scheme") IssueTypeScreenSchemeTemplateImpl issueTypeScreenSchemeTemplate, @JsonProperty(value="resolutions") List<ResolutionTemplateImpl> resolutionTemplates) {
        this.workflowSchemeTemplate = Optional.ofNullable(workflowSchemeTemplate);
        this.issueTypeSchemeTemplate = Optional.ofNullable(issueTypeSchemeTemplate);
        this.issueTypeScreenSchemeTemplate = Optional.ofNullable(issueTypeScreenSchemeTemplate);
        this.resolutionTemplates = resolutionTemplates == null ? Collections.emptyList() : resolutionTemplates;
        this.validate();
    }

    @Nonnull
    public Optional<WorkflowSchemeTemplate> workflowSchemeTemplate() {
        return this.workflowSchemeTemplate;
    }

    @Nonnull
    public Optional<IssueTypeSchemeTemplate> issueTypeSchemeTemplate() {
        return this.issueTypeSchemeTemplate;
    }

    @Nonnull
    public Optional<IssueTypeScreenSchemeTemplate> issueTypeScreenSchemeTemplate() {
        return this.issueTypeScreenSchemeTemplate;
    }

    @Nonnull
    public Collection<ResolutionTemplate> resolutionTemplates() {
        return Collections.unmodifiableList(this.resolutionTemplates);
    }

    private void validate() {
        if (this.issueTypeSchemeTemplate.isPresent()) {
            if (this.workflowSchemeTemplate.isPresent()) {
                this.checkTemplateWithIssueTypeSchemeAndWorkflowScheme();
            } else {
                this.checkTemplateWithIssueTypeSchemeButNoWorkflowScheme();
            }
            if (this.issueTypeScreenSchemeTemplate.isPresent()) {
                this.checkTemplateWithIssueTypeSchemeAndIssueTypeScreenScheme();
            } else {
                this.checkTemplateWithIssueTypeSchemeButNoIssueTypeScreenScheme();
            }
        }
    }

    private void checkTemplateWithIssueTypeSchemeButNoWorkflowScheme() {
        for (IssueTypeTemplate issueTypeTemplate : this.issueTypeSchemeTemplate.get().issueTypeTemplates()) {
            if (!issueTypeTemplate.workflow().isPresent()) continue;
            throw new IllegalArgumentException("Issue Type '" + issueTypeTemplate.key() + "' has a workflow configured, but no workflow scheme has been configured in the configuration scheme");
        }
    }

    private void checkTemplateWithIssueTypeSchemeAndWorkflowScheme() {
        HashSet workflowKeys = Sets.newHashSet();
        for (IssueTypeTemplate issueTypeTemplate : this.issueTypeSchemeTemplate.get().issueTypeTemplates()) {
            if (!issueTypeTemplate.workflow().isPresent()) continue;
            if (!this.workflowSchemeTemplate.get().hasWorkflow((String)issueTypeTemplate.workflow().get())) {
                throw new IllegalArgumentException("Issue Type '" + issueTypeTemplate.key() + "' refers to an unknown workflow key " + (String)issueTypeTemplate.workflow().get());
            }
            workflowKeys.add((String)issueTypeTemplate.workflow().get());
        }
        if (this.workflowSchemeTemplate.get().defaultWorkflow().isPresent()) {
            workflowKeys.add((String)this.workflowSchemeTemplate.get().defaultWorkflow().get());
        }
        this.checkAllDefinedWorkflowsAreUsed(workflowKeys);
    }

    private void checkAllDefinedWorkflowsAreUsed(Set<String> workflowKeys) {
        for (WorkflowTemplate workflowTemplate : this.workflowSchemeTemplate.get().workflowTemplates()) {
            if (workflowKeys.contains(workflowTemplate.key())) continue;
            throw new IllegalArgumentException("Workflow with key '" + workflowTemplate.key() + "' is defined but not used.");
        }
    }

    private void checkTemplateWithIssueTypeSchemeAndIssueTypeScreenScheme() {
        HashSet usedScreenSchemeKeys = Sets.newHashSet();
        for (IssueTypeTemplate issueTypeTemplate : this.issueTypeSchemeTemplate.get().issueTypeTemplates()) {
            if (!issueTypeTemplate.screenScheme().isPresent()) continue;
            if (!this.issueTypeScreenSchemeTemplate.get().hasScreenScheme((String)issueTypeTemplate.screenScheme().get())) {
                throw new IllegalArgumentException("Issue Type '" + issueTypeTemplate.key() + "' refers to an unknown screen scheme key " + (String)issueTypeTemplate.screenScheme().get());
            }
            usedScreenSchemeKeys.add((String)issueTypeTemplate.screenScheme().get());
        }
        usedScreenSchemeKeys.add(this.issueTypeScreenSchemeTemplate.get().defaultScreenScheme());
        this.checkAllDefinedScreenSchemesAreUsed(usedScreenSchemeKeys);
    }

    private void checkAllDefinedScreenSchemesAreUsed(Set<String> usedScreenSchemeKeys) {
        for (ScreenSchemeTemplate screenSchemeTemplate : this.issueTypeScreenSchemeTemplate.get().screenSchemeTemplates()) {
            if (usedScreenSchemeKeys.contains(screenSchemeTemplate.key())) continue;
            throw new IllegalArgumentException("Screen scheme with key '" + screenSchemeTemplate.key() + "' is defined but not used.");
        }
    }

    private void checkTemplateWithIssueTypeSchemeButNoIssueTypeScreenScheme() {
        for (IssueTypeTemplate issueTypeTemplate : this.issueTypeSchemeTemplate.get().issueTypeTemplates()) {
            if (!issueTypeTemplate.screenScheme().isPresent()) continue;
            throw new IllegalArgumentException("Issue Type '" + issueTypeTemplate.key() + "' has a screen scheme configured, but no issue type screen scheme has been configured in the configuration scheme");
        }
    }
}

