/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.project.template.hook;

import com.atlassian.jira.project.template.hook.IssueTypeSchemeTemplate;
import com.atlassian.jira.project.template.hook.IssueTypeTemplate;
import com.atlassian.jira.project.template.hook.IssueTypeTemplateImpl;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonIgnoreProperties(ignoreUnknown=true)
public class IssueTypeSchemeTemplateImpl
implements IssueTypeSchemeTemplate {
    private final String name;
    private final Optional<String> defaultIssueType;
    private final String description;
    private final List<? extends IssueTypeTemplate> issueTypeTemplateList;

    public IssueTypeSchemeTemplateImpl(@JsonProperty(value="name") String name, @JsonProperty(value="default-issue-type") String defaultIssueType, @JsonProperty(value="description") String description, @JsonProperty(value="issue-types") List<IssueTypeTemplateImpl> issueTypeTemplateList) {
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this.defaultIssueType = defaultIssueType == null ? Optional.empty() : Optional.of(defaultIssueType.toUpperCase());
        this.description = Strings.nullToEmpty((String)description);
        this.issueTypeTemplateList = (List)Preconditions.checkNotNull(issueTypeTemplateList);
        this.validate();
    }

    public String name() {
        return this.name;
    }

    public Optional<String> defaultIssueType() {
        return this.defaultIssueType;
    }

    public String description() {
        return this.description;
    }

    public List<IssueTypeTemplate> issueTypeTemplates() {
        return Collections.unmodifiableList(this.issueTypeTemplateList);
    }

    private void validate() {
        this.validateDefaultIssueType();
    }

    private void validateDefaultIssueType() {
        if (this.defaultIssueType.isPresent() && !this.hasIssueType(this.defaultIssueType.get())) {
            throw new IllegalArgumentException("Default issue type '" + this.defaultIssueType.get() + "' of issue type scheme '" + this.name + "' does not exist.");
        }
    }

    private boolean hasIssueType(String issueTypeKey) {
        for (IssueTypeTemplate issueTypeTemplate : this.issueTypeTemplateList) {
            if (!issueTypeTemplate.key().equalsIgnoreCase(issueTypeKey)) continue;
            return true;
        }
        return false;
    }
}

