/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.project.util;

import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.jira.entity.Delete;
import com.atlassian.jira.ofbiz.FieldMap;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.project.util.ProjectKeyStore;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedMap;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.ofbiz.core.entity.EntityUtil;
import org.ofbiz.core.entity.GenericValue;

public class ProjectKeyStoreImpl
implements ProjectKeyStore {
    public static final String PROJECT_KEY = "projectKey";
    public static final String PROJECT_ID = "projectId";
    public static String ENTITY_NAME = "ProjectKey";
    private final OfBizDelegator ofBizDelegator;

    public ProjectKeyStoreImpl(OfBizDelegator ofBizDelegator) {
        this.ofBizDelegator = ofBizDelegator;
    }

    @Override
    public Long getProjectId(String key) {
        GenericValue gv = EntityUtil.getOnly((List)this.ofBizDelegator.findByAnd(ENTITY_NAME, (Map)FieldMap.build((String)PROJECT_KEY, (Object)key)));
        return gv != null ? gv.getLong(PROJECT_ID) : null;
    }

    @Override
    public void addProjectKey(Long projectId, String projectKey) {
        this.ofBizDelegator.createValue(ENTITY_NAME, (Map)ImmutableMap.of((Object)PROJECT_ID, (Object)projectId, (Object)PROJECT_KEY, (Object)projectKey));
    }

    @Override
    public void deleteProjectKeys(Long projectId) {
        Delete.from("ProjectKey").whereEqual(PROJECT_ID, projectId).execute(this.ofBizDelegator);
    }

    @Override
    @Nonnull
    public Map<String, Long> getAllProjectKeys() {
        List keys = this.ofBizDelegator.findAll(ENTITY_NAME);
        if (keys == null) {
            return Collections.emptyMap();
        }
        return keys.stream().collect(Collectors.toMap(gv -> gv.getString(PROJECT_KEY), gv -> gv.getLong(PROJECT_ID)));
    }

    @Override
    @Nullable
    public Long getProjectIdByKeyIgnoreCase(String projectKey) {
        return (Long)ImmutableSortedMap.copyOf(this.getAllProjectKeys(), (Comparator)String.CASE_INSENSITIVE_ORDER).get((Object)projectKey);
    }

    @Override
    @Nonnull
    public Set<String> getProjectKeys(Long projectId) {
        List keys = this.ofBizDelegator.findByAnd(ENTITY_NAME, (Map)FieldMap.build((String)PROJECT_ID, (Object)projectId));
        if (keys == null) {
            return Collections.emptySet();
        }
        return (Set)keys.stream().map(gv -> gv.getString(PROJECT_KEY)).collect(CollectorsUtil.toImmutableSet());
    }

    @Override
    public void refresh() {
    }
}

