/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.propertyset;

import com.atlassian.jira.cluster.ClusterSafe;
import com.atlassian.jira.config.properties.BackingPropertySetManager;
import com.atlassian.jira.propertyset.AbstractJiraPropertySetFactory;
import com.atlassian.jira.propertyset.CachingOfBizPropertySet;
import com.atlassian.jira.propertyset.JiraCachingPropertySetManager;
import com.atlassian.jira.propertyset.OfBizPropertyEntryStore;
import com.atlassian.jira.util.dbc.Assertions;
import com.opensymphony.module.propertyset.PropertySet;
import javax.annotation.Nonnull;

@ClusterSafe(value="Only used during bootstrap; this component is discarded afterwards")
public class BootstrapJiraPropertySetFactory
extends AbstractJiraPropertySetFactory {
    private final BackingPropertySetManager backingPropertySetManager;
    private final OfBizPropertyEntryStore ofBizPropertyEntryStore;

    public BootstrapJiraPropertySetFactory(BackingPropertySetManager backingPropertySetManager, JiraCachingPropertySetManager jiraCachingPropertySetManager, OfBizPropertyEntryStore ofBizPropertyEntryStore) {
        super(jiraCachingPropertySetManager);
        this.backingPropertySetManager = (BackingPropertySetManager)Assertions.notNull((String)"backingPropertySetManager", (Object)backingPropertySetManager);
        this.ofBizPropertyEntryStore = (OfBizPropertyEntryStore)Assertions.notNull((String)"ofBizPropertyEntryStore", (Object)ofBizPropertyEntryStore);
    }

    @Nonnull
    public PropertySet buildCachingPropertySet(String entityName, Long entityId) {
        if (entityName.equals("jira.properties") && entityId == 1L) {
            return (PropertySet)this.backingPropertySetManager.getPropertySetSupplier().get();
        }
        return new CachingOfBizPropertySet(this.ofBizPropertyEntryStore, entityName, entityId);
    }
}

