/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.propertyset;

import com.atlassian.jira.database.DbConnection;
import com.atlassian.jira.model.querydsl.JiraRelationalPathBase;
import com.atlassian.jira.model.querydsl.QOSPropertyDate;
import com.atlassian.jira.model.querydsl.QOSPropertyDecimal;
import com.atlassian.jira.model.querydsl.QOSPropertyNumber;
import com.atlassian.jira.model.querydsl.QOSPropertyString;
import com.atlassian.jira.model.querydsl.QOSPropertyText;
import com.google.common.collect.ImmutableMap;
import com.opensymphony.module.propertyset.PropertyImplementationException;
import com.opensymphony.module.propertyset.ofbiz.DatePropertyHandler;
import com.opensymphony.module.propertyset.ofbiz.DecimalPropertyHandler;
import com.opensymphony.module.propertyset.ofbiz.NumberPropertyHandler;
import com.opensymphony.module.propertyset.ofbiz.PropertyHandler;
import com.opensymphony.module.propertyset.ofbiz.StringPropertyHandler;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.RelationalPath;
import java.util.Date;
import java.util.Map;
import javax.annotation.Nonnull;

public class OfBizPropertyTypeRegistry {
    public static final Map<Integer, TypeMapper> TYPE_MAPPER;

    @Nonnull
    public static TypeMapper mapper(int type) {
        return OfBizPropertyTypeRegistry.mapper((Integer)type);
    }

    @Nonnull
    static TypeMapper mapper(Integer type) {
        TypeMapper mapper = TYPE_MAPPER.get(type);
        if (mapper == null) {
            throw new PropertyImplementationException("Invalid property type: " + type);
        }
        return mapper;
    }

    static {
        StringPropertyHandler stringPropertyHandler = new StringPropertyHandler();
        TypeMapper propString = new TypeMapper(QOSPropertyString.O_S_PROPERTY_STRING, (Path<?>)QOSPropertyString.O_S_PROPERTY_STRING.value, (PropertyHandler)stringPropertyHandler);
        TypeMapper propText = new TypeMapper(QOSPropertyText.O_S_PROPERTY_TEXT, (Path<?>)QOSPropertyText.O_S_PROPERTY_TEXT.value, (PropertyHandler)stringPropertyHandler);
        TypeMapper propDate = new TypeMapper(QOSPropertyDate.O_S_PROPERTY_DATE, (Path<?>)QOSPropertyDate.O_S_PROPERTY_DATE.value, (PropertyHandler)new SafeDatePropertyHandler());
        TypeMapper propNumber = new TypeMapper(QOSPropertyNumber.O_S_PROPERTY_NUMBER, (Path<?>)QOSPropertyNumber.O_S_PROPERTY_NUMBER.value, (PropertyHandler)new NumberPropertyHandler());
        TypeMapper propDecimal = new TypeMapper(QOSPropertyDecimal.O_S_PROPERTY_DECIMAL, (Path<?>)QOSPropertyDecimal.O_S_PROPERTY_DECIMAL.value, (PropertyHandler)new DecimalPropertyHandler());
        TYPE_MAPPER = ImmutableMap.builder().put((Object)1, (Object)propNumber).put((Object)2, (Object)propNumber).put((Object)3, (Object)propNumber).put((Object)4, (Object)propDecimal).put((Object)5, (Object)propString).put((Object)6, (Object)propText).put((Object)7, (Object)propDate).build();
    }

    public static class TypeMapper {
        private final JiraRelationalPathBase<?> valueTable;
        private final Path<?> valuePath;
        private final PropertyHandler handler;

        public TypeMapper(JiraRelationalPathBase<?> valueTable, Path<?> valuePath, PropertyHandler handler) {
            this.valueTable = valueTable;
            this.valuePath = valuePath;
            this.handler = handler;
        }

        public String getValueEntity() {
            return this.valueTable.getEntityName();
        }

        public JiraRelationalPathBase<?> getValueTable() {
            return this.valueTable;
        }

        public Path<?> getValuePath() {
            return this.valuePath;
        }

        public PropertyHandler getHandler() {
            return this.handler;
        }

        public boolean upsert(DbConnection db, long id, Object value) {
            if (this.update(db, id, value) <= 0L) {
                this.insert(db, id, value);
            }
            return true;
        }

        public long insert(DbConnection db, long id, Object value) {
            return db.insert(this.valueTable).set((Path)this.valueTable.getNumericIdPath(), (Object)id).set((Path)this.valuePath, value).execute();
        }

        public long update(DbConnection db, long id, Object value) {
            return db.update((RelationalPath<?>)this.valueTable).set(this.valuePath, value).where((Predicate)this.valueTable.getNumericIdPath().eq((Object)id)).execute();
        }

        public long delete(DbConnection db, long id) {
            return db.delete((RelationalPath<?>)this.valueTable).where((Predicate)this.valueTable.getNumericIdPath().eq((Object)id)).execute();
        }

        public boolean hasSameEntityName(@Nonnull TypeMapper otherMapper) {
            return this.valueTable.getEntityName().equals(otherMapper.valueTable.getEntityName());
        }

        public String toString() {
            return "TypeMapper[handler=" + this.handler.getClass().getSimpleName() + ",valueEntity=" + this.getValueEntity() + "]";
        }
    }

    static class SafeDatePropertyHandler
    extends DatePropertyHandler {
        SafeDatePropertyHandler() {
        }

        public Object processGet(int type, Object input) {
            Object result = super.processGet(type, input);
            return result instanceof Date ? ((Date)result).clone() : result;
        }
    }
}

