/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.reactions;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.ServiceOutcomeImpl;
import com.atlassian.jira.bc.issue.comment.CommentService;
import com.atlassian.jira.event.comment.CommentDeletedEvent;
import com.atlassian.jira.extension.Startable;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.issue.comments.CommentPermissionManager;
import com.atlassian.jira.issue.comments.reactions.CommentReactionManager;
import com.atlassian.jira.model.querydsl.CommentReactionDTO;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.type.ProjectTypeKey;
import com.atlassian.jira.reactions.CommentReactionsEnabledService;
import com.atlassian.jira.reactions.CommentReactionsService;
import com.atlassian.jira.reactions.ReactionSummary;
import com.atlassian.jira.reactions.analytics.CommentReactionsAddedEvent;
import com.atlassian.jira.reactions.analytics.CommentReactionsRemovedEvent;
import com.atlassian.jira.reactions.analytics.CommentReactionsStats;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import io.atlassian.fugue.Either;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class DefaultCommentReactionsService
implements CommentReactionsService,
Startable {
    private final CommentReactionManager commentReactionManager;
    private final UserManager userManager;
    private final PermissionManager permissionManager;
    private final CommentService commentService;
    private final CommentReactionsEnabledService commentReactionsEnabledService;
    private final CommentPermissionManager commentPermissionManager;
    private final EventPublisher eventPublisher;

    public DefaultCommentReactionsService(CommentReactionManager commentReactionManager, UserManager userManager, PermissionManager permissionManager, CommentService commentService, CommentReactionsEnabledService commentReactionsEnabledService, CommentPermissionManager commentPermissionManager, EventPublisher eventPublisher) {
        this.commentReactionManager = commentReactionManager;
        this.userManager = userManager;
        this.permissionManager = permissionManager;
        this.commentService = commentService;
        this.commentReactionsEnabledService = commentReactionsEnabledService;
        this.commentPermissionManager = commentPermissionManager;
        this.eventPublisher = eventPublisher;
    }

    public void start() {
        this.eventPublisher.register((Object)this);
    }

    @EventListener
    public void onCommentDeleted(CommentDeletedEvent event) {
        if (Objects.nonNull(event.getComment())) {
            this.deleteCommentReactions(event.getComment().getId());
        }
    }

    private void deleteCommentReactions(long commentId) {
        this.commentReactionManager.deleteAllByCommentId(commentId);
    }

    @Override
    @Nonnull
    public ServiceOutcome<Collection<ReactionSummary>> getReactions(@Nonnull ApplicationUser loggedInUser, Collection<Long> commentIds) {
        long startTime = System.currentTimeMillis();
        if (Objects.isNull(commentIds) || commentIds.contains(null)) {
            return ServiceOutcomeImpl.error("Invalid comment id provided", ErrorCollection.Reason.VALIDATION_FAILED);
        }
        List reactionSummaryList = commentIds.stream().flatMap(id -> this.getReactionsForSingleComment(loggedInUser, (long)id).stream()).collect(Collectors.toList());
        this.eventPublisher.publish((Object)new CommentReactionsStats(commentIds.size(), System.currentTimeMillis() - startTime));
        return ServiceOutcomeImpl.ok(reactionSummaryList);
    }

    private Collection<ReactionSummary> getReactionsForSingleComment(@Nonnull ApplicationUser currentUser, long commentId) {
        Collection<CommentReactionDTO> allReactions = this.commentReactionManager.findByCommentId(commentId);
        Map<String, List<CommentReactionDTO>> emojiToReactions = DefaultCommentReactionsService.groupPreservingOrder(allReactions, CommentReactionDTO::getEmoticon);
        return emojiToReactions.entrySet().stream().map(entry -> this.reactionSummary(currentUser, commentId, (String)entry.getKey(), (Collection)entry.getValue())).collect(Collectors.toList());
    }

    @Override
    public ServiceOutcome<ReactionSummary> getDetailedReaction(@Nonnull ApplicationUser loggedInUser, Long commentId, String emoji) {
        ErrorCollection errors = this.validateParams(commentId, emoji);
        if (errors.hasAnyErrors()) {
            return ServiceOutcomeImpl.from(errors);
        }
        Collection<CommentReactionDTO> reactions = this.commentReactionManager.findByCommentAndEmoticon(commentId, emoji);
        return ServiceOutcomeImpl.ok(this.reactionSummary(loggedInUser, commentId, emoji, reactions));
    }

    @Override
    public ServiceOutcome<ReactionSummary> addReaction(@Nonnull ApplicationUser loggedInUser, long commentId, String emojiId) {
        Either<ErrorCollection, Comment> validationEither = this.validateCommentPermissions(loggedInUser, commentId);
        if (validationEither.isLeft()) {
            return ServiceOutcomeImpl.from((ErrorCollection)validationEither.left().get());
        }
        Comment comment = (Comment)validationEither.right().get();
        if (!this.commentReactionManager.exists(commentId, emojiId, loggedInUser.getKey())) {
            this.commentReactionManager.create(commentId, emojiId, loggedInUser.getKey(), Instant.now());
            this.eventPublisher.publish((Object)new CommentReactionsAddedEvent(this.getProjectTypeKeyFromComment(comment)));
        }
        Collection<CommentReactionDTO> reactions = this.commentReactionManager.findByCommentAndEmoticon(commentId, emojiId);
        return ServiceOutcomeImpl.ok(this.reactionSummary(loggedInUser, commentId, emojiId, reactions));
    }

    @Override
    public ServiceOutcome<ReactionSummary> deleteReaction(@Nonnull ApplicationUser loggedInUser, Long commentId, String emojiId) {
        SimpleErrorCollection errors = new SimpleErrorCollection();
        errors.addErrorCollection(this.validateParams(commentId, emojiId));
        Either<ErrorCollection, Comment> validationEither = this.validateCommentPermissions(loggedInUser, commentId);
        if (validationEither.isLeft()) {
            errors.addErrorCollection((ErrorCollection)validationEither.left().get());
        }
        if (errors.hasAnyErrors()) {
            return ServiceOutcomeImpl.from((ErrorCollection)errors);
        }
        Comment comment = (Comment)validationEither.right().get();
        this.commentReactionManager.delete(commentId, emojiId, loggedInUser.getKey());
        this.eventPublisher.publish((Object)new CommentReactionsRemovedEvent(this.getProjectTypeKeyFromComment(comment)));
        Collection<CommentReactionDTO> reactions = this.commentReactionManager.findByCommentAndEmoticon(commentId, emojiId);
        return ServiceOutcomeImpl.ok(this.reactionSummary(loggedInUser, commentId, emojiId, reactions));
    }

    private String getProjectTypeKeyFromComment(Comment comment) {
        ProjectTypeKey typeKey;
        Issue issue = comment.getIssue();
        Project project = issue.getProjectObject();
        if (project != null && (typeKey = project.getProjectTypeKey()) != null) {
            return typeKey.getKey();
        }
        return null;
    }

    private ReactionSummary reactionSummary(ApplicationUser currentUser, long commentId, String emoji, Collection<CommentReactionDTO> reactionsForEmoji) {
        int count = reactionsForEmoji.size();
        List userKeys = reactionsForEmoji.stream().map(CommentReactionDTO::getAuthor).distinct().collect(Collectors.toList());
        String[] userDisplayNames = (String[])userKeys.stream().map(arg_0 -> ((UserManager)this.userManager).getUserByKey(arg_0)).filter(Objects::nonNull).map(ApplicationUser::getDisplayName).toArray(String[]::new);
        boolean currentUserReacted = userKeys.contains(currentUser.getKey());
        return new ReactionSummary(commentId, emoji, count, currentUserReacted, userDisplayNames);
    }

    private boolean isCommentReactionAllowed(@Nonnull ApplicationUser user, @Nonnull Comment comment) {
        return this.permissionManager.hasPermission(ProjectPermissions.ADD_COMMENTS, comment.getIssue(), user) && this.commentPermissionManager.hasBrowsePermission(user, comment) && !comment.getIssue().isArchived();
    }

    private ErrorCollection validateParams(Long commentId, String emojiId) {
        if (Objects.isNull(commentId) || Objects.isNull(emojiId)) {
            return new SimpleErrorCollection("Invalid request parameters", ErrorCollection.Reason.VALIDATION_FAILED);
        }
        return new SimpleErrorCollection();
    }

    private Either<ErrorCollection, Comment> validateCommentPermissions(@Nonnull ApplicationUser user, Long commentId) {
        SimpleErrorCollection errors = new SimpleErrorCollection();
        if (!this.commentReactionsEnabledService.isEnabled()) {
            errors.addErrorMessage("Comment reactions are disabled", ErrorCollection.Reason.NOT_FOUND);
            return Either.left((Object)errors);
        }
        Comment comment = this.commentService.getCommentById(user, commentId, (ErrorCollection)errors);
        if (Objects.isNull(comment) || !this.isCommentReactionAllowed(user, comment)) {
            errors.addErrorMessage("This operation is not allowed", ErrorCollection.Reason.NOT_FOUND);
        }
        return errors.hasAnyErrors() ? Either.left((Object)errors) : Either.right((Object)comment);
    }

    private static <T> Map<String, List<T>> groupPreservingOrder(Collection<T> coll, Function<T, String> fun) {
        LinkedHashMap<String, List<T>> map = new LinkedHashMap<String, List<T>>();
        for (T elem : coll) {
            String key = fun.apply(elem);
            map.computeIfAbsent(key, _key -> new ArrayList()).add(elem);
        }
        return map;
    }
}

