/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.retranslate;

import com.atlassian.jira.database.DatabaseSchema;
import com.atlassian.jira.database.QueryDslAccessor;
import com.atlassian.jira.retranslate.KeyReplacementHelper;
import com.atlassian.jira.retranslate.ReTranslateKeysServiceImpl;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.lang.Pair;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.StringPath;
import com.querydsl.sql.Configuration;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.RelationalPathBase;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.SQLTemplates;
import com.querydsl.sql.SQLTemplatesRegistry;
import com.querydsl.sql.dml.SQLUpdateClause;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AOReTranslateKeysHelper {
    static final String UNRECOGNIZED_TABLE_NAME_ = "Unrecognized table name ";
    static final String UNRECOGNIZED_COLUMN_NAME_ = "Unrecognized column name ";
    static final String NO_TRANSLATION_FOR_KEY_ = "No translation exists for key ";
    private static final Logger log = LoggerFactory.getLogger(AOReTranslateKeysHelper.class);
    private final KeyReplacementHelper keyReplacementHelper;
    private final QueryDslAccessor queryDslAccessor;

    public AOReTranslateKeysHelper(KeyReplacementHelper keyReplacementHelper, QueryDslAccessor queryDslAccessor) {
        this.keyReplacementHelper = keyReplacementHelper;
        this.queryDslAccessor = queryDslAccessor;
    }

    public List<Pair<String, String>> dryRunReTranslateAllKeys(String tableName, String columnName, String key) {
        log.info("[RETRANSLATE-KEYS] Starting Dry-run of retranslate-keys (AO). Key: '" + key + "'. Table name: '" + tableName + "'. Column name: '" + columnName + "'.");
        List<Pair<String, String>> results = this.doDryRun(tableName, columnName, key);
        log.info("[RETRANSLATE-KEYS] Dry-run of translate-keys succeeded (AO). Found " + results.size() + " rows with translations. Key: '" + key + "'. Table name: '" + tableName + "'. Column name: '" + columnName + "'.");
        return results;
    }

    private List<Pair<String, String>> doDryRun(String tableName, String columnName, String key) {
        this.verifyTableAndColumn(tableName, columnName);
        List<String> dbEntriesWithKey = this.findRowsWithKey(tableName, columnName, key);
        return dbEntriesWithKey.stream().map(orig -> Pair.of((Object)orig, (Object)this.keyReplacementHelper.replaceKeyWithTranslation(key, (String)orig))).filter(ba -> !StringUtils.equals((CharSequence)((CharSequence)ba.first()), (CharSequence)((CharSequence)ba.second()))).collect(Collectors.toList());
    }

    public List<Pair<String, String>> reTranslateAllKeys(String tableName, String columnName, String key) {
        log.info("[RETRANSLATE-KEYS] Beginning key retranslation (AO). Key: '" + key + "'. Table name: '" + tableName + "'. Column name: '" + columnName + "'.");
        List<Pair<String, String>> updates = this.doDryRun(tableName, columnName, key);
        updates.stream().collect(Collectors.toSet()).forEach(ba -> {
            log.info("[RETRANSLATE-KEYS] about to update rows containing '" + (String)ba.first() + "' with '" + (String)ba.second() + "'.");
            long numRowsUpdated = this.translateAffectedRows(tableName, columnName, (Pair<String, String>)ba);
            log.info("[RETRANSLATE-KEYS] Successfully updated " + numRowsUpdated + " rows");
        });
        log.info("[RETRANSLATE-KEYS] Retranslating keys succeeded. Updated " + updates.size() + " rows with translations.");
        return updates;
    }

    private List<String> findRowsWithKey(String tableName, String columnName, String key) {
        if (this.keyReplacementHelper.noI18nTranslationExists(key)) {
            throw new ReTranslateKeysServiceImpl.ReTranslateException(NO_TRANSLATION_FOR_KEY_ + key, ErrorCollection.Reason.VALIDATION_FAILED);
        }
        return this.queryDslAccessor.withNewConnection().executeQuery(cb -> {
            RelationalPath<Object> tablePath = this.makeTablePath(tableName);
            StringPath colPath = Expressions.stringPath(tablePath, (String)columnName);
            SQLQuery sqlQuery = (SQLQuery)this.prepQuotedQuery(cb.getJdbcConnection()).select((Expression)colPath).from(tablePath).where((Predicate)colPath.like("%" + key + "%"));
            return sqlQuery.fetch();
        });
    }

    private RelationalPath<Object> makeTablePath(String tableName) {
        String aliases = "tableNameAlias";
        String schema = DatabaseSchema.getSchemaName();
        return new RelationalPathBase(Object.class, "tableNameAlias", schema, tableName);
    }

    private SQLQuery prepQuotedQuery(Connection conn) {
        SQLQuery q = new SQLQuery(conn, this.prepareConfiguration(conn));
        q.setUseLiterals(true);
        return q;
    }

    private long translateAffectedRows(String tableName, String columnName, Pair<String, String> beforeAfter) {
        Long numUpdated = this.queryDslAccessor.withNewConnection().executeQuery(cb -> {
            RelationalPath<Object> tablePath = this.makeTablePath(tableName);
            StringPath colPath = Expressions.stringPath(tablePath, (String)columnName);
            SQLUpdateClause updater = new SQLUpdateClause(cb.getJdbcConnection(), this.prepareConfiguration(cb.getJdbcConnection()), this.makeTablePath(tableName));
            return updater.where((Predicate)colPath.eq((Object)((String)beforeAfter.first()))).set((Path)colPath, (Object)((String)beforeAfter.second())).execute();
        });
        return numUpdated;
    }

    private Configuration prepareConfiguration(Connection conn) {
        Configuration config;
        try {
            SQLTemplates template = new SQLTemplatesRegistry().getBuilder(conn.getMetaData()).quote().build();
            config = new Configuration(template);
        }
        catch (SQLException e) {
            log.error("[RETRANSLATE-KEYS] Problems preparing QueryDSL Configuration: " + e);
            throw new ReTranslateKeysServiceImpl.ReTranslateException("Problems preparing Query. See Jira log for more details.", ErrorCollection.Reason.SERVER_ERROR);
        }
        config.setUseLiterals(true);
        return config;
    }

    private void verifyTableAndColumn(String tableName, String columnName) {
        if (!tableName.startsWith("AO_")) {
            String errorMsg = "Validation failed: tableName'" + tableName + "' did not start with the expected 'AO_' prefix";
            log.warn("[RETRANSLATE-KEYS] " + errorMsg);
            throw new ReTranslateKeysServiceImpl.ReTranslateException(errorMsg, ErrorCollection.Reason.VALIDATION_FAILED);
        }
        this.queryDslAccessor.withNewConnection().execute(cb -> {
            this.verifyTableExists(tableName, cb.getJdbcConnection());
            this.verifyColumnExists(tableName, columnName, cb.getJdbcConnection());
        });
    }

    private void verifyTableExists(String tableName, Connection conn) {
        boolean exists = false;
        try {
            ResultSet results = conn.getMetaData().getTables(conn.getCatalog(), null, null, new String[]{"TABLE"});
            while (results.next() && !exists) {
                if (!tableName.equals(results.getString("TABLE_NAME"))) continue;
                exists = true;
            }
        }
        catch (SQLException e) {
            String errorMsg = "Error while checking the existence of table " + tableName;
            log.error("[RETRANSLATE-KEYS] " + errorMsg + ": " + e);
            throw new ReTranslateKeysServiceImpl.ReTranslateException("Error while checking the existence of table " + tableName + ". Please see the Jira log for more details", ErrorCollection.Reason.SERVER_ERROR);
        }
        if (!exists) {
            log.warn("[RETRANSLATE-KEYS] Unrecognized table name " + tableName);
            throw new ReTranslateKeysServiceImpl.ReTranslateException(UNRECOGNIZED_TABLE_NAME_ + tableName, ErrorCollection.Reason.VALIDATION_FAILED);
        }
    }

    private void verifyColumnExists(String tableName, String columnName, Connection conn) {
        boolean exists = false;
        try {
            ResultSet results = conn.getMetaData().getColumns(null, null, tableName, null);
            while (results.next() && !exists) {
                if (!columnName.equals(results.getString("COLUMN_NAME"))) continue;
                exists = true;
            }
        }
        catch (SQLException e) {
            String errorMsg = "Error while checking the existence of column " + columnName;
            log.error("[RETRANSLATE-KEYS] " + errorMsg + ": " + e);
            throw new ReTranslateKeysServiceImpl.ReTranslateException(errorMsg + ". Please see the Jira log for more details", ErrorCollection.Reason.SERVER_ERROR);
        }
        if (!exists) {
            log.warn("[RETRANSLATE-KEYS] Unrecognized column name " + columnName);
            throw new ReTranslateKeysServiceImpl.ReTranslateException(UNRECOGNIZED_COLUMN_NAME_ + columnName, ErrorCollection.Reason.VALIDATION_FAILED);
        }
    }
}

