/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.retranslate;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.retranslate.KeyReplacementHelper;
import com.atlassian.jira.retranslate.ReTranslateKeysServiceImpl;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.lang.Pair;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import org.apache.commons.lang3.StringUtils;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;
import org.ofbiz.core.entity.jdbc.SqlJdbcUtil;
import org.ofbiz.core.entity.model.ModelEntity;
import org.ofbiz.core.entity.model.ModelField;
import org.ofbiz.core.entity.model.ModelFieldType;
import org.ofbiz.core.entity.model.ModelReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JiraReTranslateKeysHelper {
    static final String UNRECOGNIZED_ENTITY_NAME_ = "Unrecognized entity name ";
    static final String UNRECOGNIZED_FIELD_NAME_ = "Unrecognized field name ";
    static final String NO_TRANSLATION_FOR_KEY_ = "No translation exists for key ";
    private static final Logger log = LoggerFactory.getLogger(JiraReTranslateKeysHelper.class);
    private final KeyReplacementHelper keyReplacementHelper;
    private final OfBizDelegator ofBizDelegator;
    private final EventPublisher eventPublisher;

    public JiraReTranslateKeysHelper(KeyReplacementHelper keyReplacementHelper, OfBizDelegator ofBizDelegator, EventPublisher eventPublisher) {
        this.keyReplacementHelper = keyReplacementHelper;
        this.ofBizDelegator = ofBizDelegator;
        this.eventPublisher = eventPublisher;
    }

    public List<Pair<String, String>> dryRunReTranslateAllKeys(String targetEntityName, String targetFieldName, String key) {
        log.info("[RETRANSLATE-KEYS] Starting Dry-run of retranslate-keys. Key: '" + key + "'. Entity: '" + targetEntityName + "'. Field: '" + targetEntityName + "'.");
        BiConsumer<Object, Object> noop = (a, b) -> {};
        List<Pair<String, String>> results = this.collectTranslations(key, targetEntityName, targetFieldName, noop);
        log.info("[RETRANSLATE-KEYS] Dry-run of translate-keys succeeded. Found " + results.size() + " rows with translations. Key: '" + key + "'. Entity: '" + targetEntityName + "'. Field: '" + targetEntityName + "'.");
        return results;
    }

    public List<Pair<String, String>> reTranslateAllKeys(String targetEntityName, String targetFieldName, String key) {
        log.info("[RETRANSLATE-KEYS] Beginning key retranslation. Key: '" + key + "'. Entity name: '" + targetEntityName + "'. Field name: '" + targetFieldName + "'.");
        List<Pair<String, String>> changed = this.collectTranslations(key, targetEntityName, targetFieldName, (ba, gv) -> this.storeTranslation(targetFieldName, (GenericValue)gv, (Pair<String, String>)ba));
        if (!changed.isEmpty()) {
            this.clearAllRelatedCaches();
        }
        log.info("[RETRANSLATE-KEYS] Retranslating keys succeeded. Updated " + changed.size() + " rows with translations.");
        return changed;
    }

    private List<Pair<String, String>> collectTranslations(String key, String targetEntityName, String targetFieldName, BiConsumer<Pair<String, String>, GenericValue> modifier) {
        this.verifyEntityAndField(targetEntityName, targetFieldName);
        if (this.keyReplacementHelper.noI18nTranslationExists(key)) {
            throw new ReTranslateKeysServiceImpl.ReTranslateException(NO_TRANSLATION_FOR_KEY_ + key, ErrorCollection.Reason.VALIDATION_FAILED);
        }
        ArrayList<Pair<String, String>> translations = new ArrayList<Pair<String, String>>();
        for (GenericValue gv : this.ofBizDelegator.findByLike(targetEntityName, (Map)ImmutableMap.of((Object)targetFieldName, (Object)("%" + key + "%")))) {
            String originalText = gv.getString(targetFieldName);
            String translatedText = this.keyReplacementHelper.replaceKeyWithTranslation(key, originalText);
            if (StringUtils.isEmpty((CharSequence)originalText) || originalText.equals(translatedText)) continue;
            Pair beforeAfter = Pair.of((Object)originalText, (Object)translatedText);
            modifier.accept((Pair<String, String>)beforeAfter, gv);
            translations.add((Pair<String, String>)beforeAfter);
        }
        return translations;
    }

    private void storeTranslation(String targetFieldName, GenericValue gv, Pair<String, String> beforeAfter) {
        gv.setString(targetFieldName, (String)beforeAfter.second());
        try {
            gv.store();
            log.info("[RETRANSLATE-KEYS] Translated '" + (String)beforeAfter.first() + "' to '" + (String)beforeAfter.second() + "'.");
        }
        catch (Throwable e) {
            String errorMessage = "Problems storing translation: '" + (String)beforeAfter.first() + "' ---> '" + (String)beforeAfter.second() + "'";
            log.error("[RETRANSLATE-KEYS] " + errorMessage + ": " + e);
            throw new ReTranslateKeysServiceImpl.ReTranslateException(errorMessage + ". Please see the Jira log for more details.", ErrorCollection.Reason.SERVER_ERROR);
        }
    }

    void clearAllRelatedCaches() {
        try {
            log.info("[RETRANSLATE-KEYS] Resetting all related caches.");
            this.eventPublisher.publish((Object)ClearCacheEvent.INSTANCE);
        }
        catch (Exception e) {
            log.error("[RETRANSLATE-KEYS] Error when clearing all related caches: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private void verifyEntityAndField(String entityName, String fieldName) {
        ModelReader modelReader = this.ofBizDelegator.getModelReader();
        try {
            if (!modelReader.getEntityNames().contains(entityName)) {
                log.warn("[RETRANSLATE-KEYS] Validation Failed: Unrecognized entity name " + entityName);
                throw new ReTranslateKeysServiceImpl.ReTranslateException(UNRECOGNIZED_ENTITY_NAME_ + entityName, ErrorCollection.Reason.VALIDATION_FAILED);
            }
            if (!modelReader.getModelEntity(entityName).isField(fieldName)) {
                log.warn("[RETRANSLATE-KEYS] Validation Failed: Unrecognized field name " + fieldName + " for entity " + entityName);
                throw new ReTranslateKeysServiceImpl.ReTranslateException(UNRECOGNIZED_FIELD_NAME_ + fieldName + " for entity " + entityName, ErrorCollection.Reason.VALIDATION_FAILED);
            }
            this.verifyFieldIsOfStringType(entityName, fieldName);
        }
        catch (GenericEntityException e) {
            log.error("[RETRANSLATE-KEYS] Problems examining db model: " + e);
            throw new ReTranslateKeysServiceImpl.ReTranslateException("Problems examining db model for entityname '" + entityName + "' and fieldname: '" + fieldName + "'. See the Jira log for more details.", ErrorCollection.Reason.SERVER_ERROR);
        }
    }

    private void verifyFieldIsOfStringType(String entityName, String fieldName) throws GenericEntityException {
        ModelEntity modelEnt = this.ofBizDelegator.getModelReader().getModelEntity(entityName);
        ModelField field = modelEnt.getField(fieldName);
        ModelFieldType modelFieldType = this.ofBizDelegator.getDelegatorInterface().getEntityFieldType(modelEnt, field.getType());
        SqlJdbcUtil.FieldType fieldType = SqlJdbcUtil.getFieldType((String)modelFieldType.getJavaType());
        if (!SqlJdbcUtil.FieldType.STRING.equals((Object)fieldType)) {
            String errorMsg = "Field '" + fieldName + "' isn't a String-like type! Type: " + fieldType;
            log.warn("[RETRANSLATE-KEYS] Validation failed: " + errorMsg);
            throw new ReTranslateKeysServiceImpl.ReTranslateException(errorMsg, ErrorCollection.Reason.VALIDATION_FAILED);
        }
    }
}

