/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.retranslate;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.util.I18nHelper;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class KeyReplacementHelper {
    static final String NO_TRANSLATION_FOUND_FOR_KEY = "No translation found for key: ";
    private final ApplicationProperties appProps;
    private final I18nHelper.BeanFactory i18nFactory;
    private final Logger log;

    public KeyReplacementHelper(ApplicationProperties appProps, I18nHelper.BeanFactory i18nFactory) {
        this.appProps = appProps;
        this.i18nFactory = i18nFactory;
        this.log = LoggerFactory.getLogger(this.getClass());
    }

    public String replaceKeyWithTranslation(String key, String originalText) {
        if (StringUtils.isEmpty((CharSequence)key) || StringUtils.isEmpty((CharSequence)originalText)) {
            return originalText;
        }
        String translatedKey = this.getI18nHelper().getText(key);
        return originalText.replace(key, translatedKey);
    }

    boolean noI18nTranslationExists(String key) {
        if (this.getI18nHelper().isKeyDefined(key)) {
            return false;
        }
        this.log.info("[RETRANSLATE-KEYS] No translation found for key: " + key);
        return true;
    }

    private I18nHelper getI18nHelper() {
        return this.i18nFactory.getInstance(this.appProps.getDefaultLocale());
    }
}

