/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.sal;

import com.atlassian.extras.api.Product;
import com.atlassian.jira.cluster.ClusterNodePropertiesImpl;
import com.atlassian.jira.config.properties.JiraSystemProperties;
import com.atlassian.jira.config.util.JiraHome;
import com.atlassian.jira.util.BuildUtilsInfo;
import com.atlassian.jira.util.http.JiraUrl;
import com.atlassian.jira.web.ExecutingHttpRequest;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Date;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;

public class JiraApplicationProperties
implements ApplicationProperties {
    private final JiraHome jiraHome;
    private final com.atlassian.jira.config.properties.ApplicationProperties jiraApplicationProperties;
    private final BuildUtilsInfo buildUtilsInfo;
    private final Supplier<String> canonicalBaseUrl = this::getCanonicalBaseUrl;
    private final Supplier<String> canonicalContextPath = this::getCanonicalContextPath;

    public JiraApplicationProperties(JiraHome jiraHome, com.atlassian.jira.config.properties.ApplicationProperties jiraApplicationProperties, BuildUtilsInfo buildUtilsInfo) {
        this.jiraHome = jiraHome;
        this.jiraApplicationProperties = jiraApplicationProperties;
        this.buildUtilsInfo = buildUtilsInfo;
    }

    public String getBaseUrl() {
        return this.getBaseUrl(UrlMode.CANONICAL);
    }

    @Nonnull
    public String getBaseUrl(UrlMode urlMode) {
        switch (urlMode) {
            case CANONICAL: {
                return this.getCanonicalBaseUrl();
            }
            case ABSOLUTE: {
                return this.getBaseUrlFromRequest().orElseGet(this.canonicalBaseUrl);
            }
            case RELATIVE: {
                return this.getContextPathFromRequest().orElseGet(this.canonicalContextPath);
            }
            case RELATIVE_CANONICAL: {
                return this.getCanonicalContextPath();
            }
            case AUTO: {
                return this.getContextPathFromRequest().orElseGet(this.canonicalBaseUrl);
            }
        }
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public String getApplicationName() {
        return this.jiraApplicationProperties.getText("jira.title");
    }

    @Nonnull
    public String getDisplayName() {
        return Product.JIRA.getName();
    }

    @Nonnull
    public String getPlatformId() {
        return this.getHamsPlatformId();
    }

    @Nonnull
    public String getHamsPlatformId() {
        return Product.JIRA.getNamespace();
    }

    @Nonnull
    public String getVersion() {
        return this.buildUtilsInfo.getVersion();
    }

    @Nonnull
    public Date getBuildDate() {
        return this.buildUtilsInfo.getCurrentBuildDate();
    }

    @Nonnull
    public String getBuildNumber() {
        return this.buildUtilsInfo.getCurrentBuildNumber();
    }

    @Deprecated
    public File getHomeDirectory() {
        return this.jiraHome.getHome();
    }

    @Nonnull
    public Optional<Path> getLocalHomeDirectory() {
        return Optional.of(this.jiraHome.getLocalHome().toPath());
    }

    @Nonnull
    public Optional<Path> getSharedHomeDirectory() {
        ClusterNodePropertiesImpl clusterNodeProperties = new ClusterNodePropertiesImpl(this.jiraHome);
        String sharedHomePath = clusterNodeProperties.getSharedHome();
        if (StringUtils.isEmpty((CharSequence)sharedHomePath)) {
            return Optional.empty();
        }
        return Optional.of(Paths.get(sharedHomePath, new String[0]));
    }

    public String getPropertyValue(String key) {
        return this.jiraApplicationProperties.getDefaultBackedString(key);
    }

    @Nonnull
    public String getApplicationFileEncoding() {
        return JiraSystemProperties.getInstance().getProperty("file.encoding", "UTF-8");
    }

    private String getCanonicalBaseUrl() {
        return this.jiraApplicationProperties.getText("jira.baseurl");
    }

    private String getCanonicalContextPath() {
        String baseUrl = this.getCanonicalBaseUrl();
        try {
            return new URL(baseUrl).getPath();
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("Base URL misconfigured", e);
        }
    }

    private Optional<String> getBaseUrlFromRequest() {
        HttpServletRequest request = ExecutingHttpRequest.get();
        if (request != null) {
            return Optional.of(JiraUrl.constructBaseUrl((HttpServletRequest)request));
        }
        return Optional.empty();
    }

    private Optional<String> getContextPathFromRequest() {
        HttpServletRequest request = ExecutingHttpRequest.get();
        if (request != null) {
            return Optional.of(request.getContextPath());
        }
        return Optional.empty();
    }
}

