/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.scheduler;

import com.atlassian.jira.config.database.DatabaseConfigurationManager;
import com.atlassian.jira.database.DatabaseSchema;
import com.atlassian.jira.ofbiz.OfBizConnectionFactory;
import com.atlassian.jira.startup.StartupCheck;
import com.atlassian.jira.upgrade.util.UpgradeUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import com.opensymphony.util.TextUtils;
import io.atlassian.fugue.Either;
import io.atlassian.util.concurrent.LazyReference;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OracleClusteredJobParametersTypeFixer {
    private static final Logger LOG = LoggerFactory.getLogger(OracleClusteredJobParametersTypeFixer.class);
    private static final String NAME = "Oracle clusteredjob.parameters type check";
    static final Set<String> INDEXES = ImmutableSet.of((Object)"pk_clusteredjob", (Object)"clusteredjob_jobid_idx", (Object)"clusteredjob_jrk_idx", (Object)"clusteredjob_nextrun_idx");
    private final DatabaseConfigurationManager dbConfigManager;
    private final OfBizConnectionFactory ofBizConnectionFactory;
    private final LazyReference<Either<Exception, Boolean>> resultRef = new LazyReference<Either<Exception, Boolean>>(){

        protected Either<Exception, Boolean> create() {
            try {
                return Either.right((Object)OracleClusteredJobParametersTypeFixer.this.applyFix());
            }
            catch (Exception e) {
                return Either.left((Object)e);
            }
        }
    };

    public OracleClusteredJobParametersTypeFixer(DatabaseConfigurationManager dbConfigManager, OfBizConnectionFactory ofBizConnectionFactory) {
        this.dbConfigManager = dbConfigManager;
        this.ofBizConnectionFactory = ofBizConnectionFactory;
    }

    private boolean isFixNeeded() {
        return this.dbConfigManager.isDatabaseSetup() && this.dbConfigManager.getDatabaseConfiguration().isOracle() && !"BLOB".equalsIgnoreCase(this.getParametersColumnType());
    }

    @VisibleForTesting
    Either<Exception, Boolean> getResult() {
        return Objects.requireNonNull((Either)this.resultRef.get());
    }

    public boolean fix() {
        return (Boolean)this.getResult().getOrElse((Object)false);
    }

    public StartupCheck asStartupCheck() {
        return new StartupCheckView();
    }

    private boolean applyFix() throws SQLException {
        if (!this.isFixNeeded()) {
            return false;
        }
        String schema = this.getSchemaName();
        Object prefix = schema.isEmpty() ? "" : schema + ".";
        try (Connection conn = this.getConnection();){
            OracleClusteredJobParametersTypeFixer.fixParametersColumn(conn, (String)prefix);
            OracleClusteredJobParametersTypeFixer.fixIndexes(conn, (String)prefix);
        }
        LOG.info("JRA-47267: Successfully changed type of clusteredjob.parameters from LONG RAW to BLOB.");
        return true;
    }

    @VisibleForTesting
    String getParametersColumnType() {
        String clusteredJob = UpgradeUtils.getExactTableName("ClusteredJob");
        return UpgradeUtils.getColumnType(clusteredJob, "parameters");
    }

    @VisibleForTesting
    String getSchemaName() {
        return DatabaseSchema.getSchemaName();
    }

    @VisibleForTesting
    Connection getConnection() throws SQLException {
        return this.ofBizConnectionFactory.getConnection();
    }

    private static void fixParametersColumn(Connection conn, String prefix) throws SQLException {
        try (Statement statement = conn.createStatement();){
            statement.execute("ALTER TABLE " + prefix + "clusteredjob MODIFY (parameters BLOB)");
        }
    }

    private static void fixIndexes(Connection conn, String prefix) {
        INDEXES.forEach(index -> OracleClusteredJobParametersTypeFixer.fixIndex(conn, prefix, index));
    }

    private static void fixIndex(Connection conn, String prefix, String index) {
        try (Statement statement = conn.createStatement();){
            statement.execute("ALTER INDEX " + prefix + index + " REBUILD");
        }
        catch (SQLException sqle) {
            LOG.warn("Rebuild unexpectedly failed for index '{}': {}", (Object)index, (Object)sqle.toString());
            LOG.debug("Full stack trace", (Throwable)sqle);
        }
    }

    class StartupCheckView
    implements StartupCheck {
        StartupCheckView() {
        }

        @Override
        public String getName() {
            return OracleClusteredJobParametersTypeFixer.NAME;
        }

        @Override
        public boolean isOk() {
            return OracleClusteredJobParametersTypeFixer.this.getResult().isRight();
        }

        @Override
        @Nullable
        public String getFaultDescription() {
            return (String)OracleClusteredJobParametersTypeFixer.this.getResult().fold(e -> "\n\n" + StringUtils.repeat((String)"*", (int)100) + "\n" + e + "\n" + StringUtils.repeat((String)"*", (int)100) + "\n", result -> null);
        }

        @Override
        @Nullable
        public String getHTMLFaultDescription() {
            return (String)OracleClusteredJobParametersTypeFixer.this.getResult().fold(e -> TextUtils.plainTextToHtml((String)e.toString()), result -> null);
        }
    }
}

