/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.scheme;

import com.atlassian.jira.scheme.AbstractSchemeAwareAction;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import org.ofbiz.core.entity.GenericValue;

public abstract class AbstractEditScheme
extends AbstractSchemeAwareAction {
    private String name;
    private String description;

    protected void doValidation() {
        this.doNameValidation(this.name, "edit");
        super.doValidation();
    }

    @RequiresXsrfCheck
    @SupportedMethods(value={RequestMethod.POST})
    protected String doExecute() throws Exception {
        GenericValue updatedScheme = this.getScheme();
        updatedScheme.setString("name", this.name);
        updatedScheme.setString("description", this.description);
        this.getSchemeManager().updateScheme(updatedScheme);
        return this.returnCompleteWithInlineRedirect(this.getRedirectURL());
    }

    @SupportedMethods(value={RequestMethod.GET})
    public String doDefault() throws Exception {
        this.setName(this.getScheme().getString("name"));
        this.setDescription(this.getScheme().getString("description"));
        return super.doDefault();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }
}

