/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.scheme;

import com.atlassian.jira.scheme.AbstractProjectAndSchemeAwareAction;
import com.atlassian.jira.scheme.Scheme;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.opensymphony.util.TextUtils;
import java.util.Collection;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public abstract class AbstractSelectProjectScheme
extends AbstractProjectAndSchemeAwareAction {
    private String[] schemeIds = new String[]{""};

    @SupportedMethods(value={RequestMethod.GET})
    public String doDefault() throws Exception {
        Scheme schemeFor;
        if (this.getProject() != null && (schemeFor = this.getSchemeManager().getSchemeFor(this.getProject())) != null && schemeFor.getId() != null) {
            this.setSchemeIds(new String[]{schemeFor.getId().toString()});
        }
        if (this.hasPermission()) {
            return super.doDefault();
        }
        return "securitybreach";
    }

    protected void doValidation() {
        if (this.getProject() == null) {
            this.addErrorMessage("You must select a project for this scheme");
        }
    }

    @RequiresXsrfCheck
    @SupportedMethods(value={RequestMethod.POST})
    protected String doExecute() throws Exception {
        this.getSchemeManager().removeSchemesFromProject(this.getProject());
        for (String schemeId : this.getSchemeIds()) {
            if (!TextUtils.stringSet((String)schemeId)) continue;
            Scheme scheme = this.getSchemeManager().getSchemeObject(new Long(schemeId));
            this.getSchemeManager().addSchemeToProject(this.getProject(), scheme);
        }
        if (this.hasPermission()) {
            return this.getRedirect(this.getProjectReturnUrl());
        }
        return "securitybreach";
    }

    @Override
    public String getRedirectURL() {
        return null;
    }

    protected String getProjectReturnUrl() {
        return "/plugins/servlet/project-config/" + this.getProject().getKey() + "/summary";
    }

    protected boolean hasPermission() {
        return this.getPermissionManager().hasPermission(0, this.getLoggedInUser());
    }

    public Collection<GenericValue> getSchemes() throws GenericEntityException {
        return this.getSchemeManager().getSchemes();
    }

    public String[] getSchemeIds() {
        return this.schemeIds;
    }

    public void setSchemeIds(String[] schemeIds) {
        this.schemeIds = schemeIds;
    }
}

