/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security;

import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.jira.application.ApplicationRoleManager;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.exception.RemoveException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.permission.LegacyProjectPermissionKeyMapping;
import com.atlassian.jira.permission.ProjectPermission;
import com.atlassian.jira.permission.ProjectPermissionCategory;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectCategory;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.ProjectWidePermission;
import com.atlassian.jira.security.plugin.ProjectPermissionKey;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.opensymphony.workflow.loader.ActionDescriptor;
import io.atlassian.fugue.Option;
import java.util.Collection;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ApplicationRequiredPermissionManager
implements PermissionManager {
    private final PermissionManager permissionManager;
    private static final Set<ProjectPermissionKey> blockedPermissions = ImmutableSet.of((Object)ProjectPermissions.ADMINISTER_PROJECTS);

    public ApplicationRequiredPermissionManager(PermissionManager permissionManager) {
        this.permissionManager = (PermissionManager)Assertions.notNull((String)"permissionManager", (Object)permissionManager);
    }

    public Collection<ProjectPermission> getAllProjectPermissions() {
        return this.permissionManager.getAllProjectPermissions();
    }

    public Collection<ProjectPermission> getProjectPermissions(@Nonnull ProjectPermissionCategory category) {
        return this.permissionManager.getProjectPermissions(category);
    }

    @Deprecated
    public boolean hasPermission(int permissionsId, ApplicationUser user) {
        return this.permissionManager.hasPermission(permissionsId, user);
    }

    public Option<ProjectPermission> getProjectPermission(@Nonnull ProjectPermissionKey permissionKey) {
        return this.permissionManager.getProjectPermission(permissionKey);
    }

    @Deprecated
    public boolean hasPermission(int permissionsId, Issue issue, ApplicationUser user) {
        return this.checkUserHasApplicationOrFalse(user, permissionsId, () -> this.permissionManager.hasPermission(permissionsId, issue, user));
    }

    public boolean hasPermission(@Nonnull ProjectPermissionKey permissionKey, @Nonnull Issue issue, @Nullable ApplicationUser user) {
        return this.checkUserHasApplicationOrFalse(user, permissionKey, () -> this.permissionManager.hasPermission(permissionKey, issue, user));
    }

    public boolean hasPermission(@Nonnull ProjectPermissionKey permissionKey, @Nonnull Issue issue, @Nullable ApplicationUser user, @Nullable ActionDescriptor actionDescriptor) {
        return this.checkUserHasApplicationOrFalse(user, permissionKey, () -> this.permissionManager.hasPermission(permissionKey, issue, user, actionDescriptor));
    }

    public boolean hasPermission(@Nonnull ProjectPermissionKey permissionKey, @Nonnull Issue issue, @Nullable ApplicationUser user, @Nonnull Status status) {
        return this.checkUserHasApplicationOrFalse(user, permissionKey, () -> this.permissionManager.hasPermission(permissionKey, issue, user, status));
    }

    @Deprecated
    public boolean hasPermission(int permissionsId, Project project, ApplicationUser user) {
        return this.checkUserHasApplicationOrFalse(user, permissionsId, () -> this.permissionManager.hasPermission(permissionsId, project, user));
    }

    public boolean hasPermission(@Nonnull ProjectPermissionKey permissionKey, @Nonnull Project project, @Nullable ApplicationUser user) {
        return this.checkUserHasApplicationOrFalse(user, permissionKey, () -> this.permissionManager.hasPermission(permissionKey, project, user));
    }

    @Nonnull
    public ProjectWidePermission hasProjectWidePermission(@Nonnull ProjectPermissionKey permissionKey, @Nonnull Project project, @Nullable ApplicationUser user) {
        return this.checkUserHasApplicationOrElse(user, permissionKey, () -> this.permissionManager.hasProjectWidePermission(permissionKey, project, user), () -> ProjectWidePermission.NO_ISSUES);
    }

    @Deprecated
    public boolean hasPermission(int permissionsId, Project project, ApplicationUser user, boolean issueCreation) {
        return this.checkUserHasApplicationOrFalse(user, permissionsId, () -> this.permissionManager.hasPermission(permissionsId, project, user, issueCreation));
    }

    public boolean hasPermission(@Nonnull ProjectPermissionKey permissionKey, @Nonnull Project project, @Nullable ApplicationUser user, boolean issueCreation) {
        return this.checkUserHasApplicationOrFalse(user, permissionKey, () -> this.permissionManager.hasPermission(permissionKey, project, user, issueCreation));
    }

    public void removeGroupPermissions(String group) throws RemoveException {
        this.permissionManager.removeGroupPermissions(group);
    }

    public void removeUserPermissions(ApplicationUser user) throws RemoveException {
        this.permissionManager.removeUserPermissions(user);
    }

    @Deprecated
    public boolean hasProjects(int permissionId, ApplicationUser user) {
        return this.checkUserHasApplicationOrFalse(user, permissionId, () -> this.permissionManager.hasProjects(permissionId, user));
    }

    public boolean hasProjects(@Nonnull ProjectPermissionKey permissionKey, @Nullable ApplicationUser user) {
        return this.checkUserHasApplicationOrFalse(user, permissionKey, () -> this.permissionManager.hasProjects(permissionKey, user));
    }

    public Collection<Project> getProjects(@Nonnull ProjectPermissionKey permissionKey, @Nullable ApplicationUser user) {
        return this.checkUserHasApplicationOrEmpty(user, permissionKey, () -> this.permissionManager.getProjects(permissionKey, user));
    }

    public Collection<Project> getProjects(@Nonnull ProjectPermissionKey permissionKey, @Nullable ApplicationUser user, @Nullable ProjectCategory projectCategory) {
        return this.checkUserHasApplicationOrEmpty(user, permissionKey, () -> this.permissionManager.getProjects(permissionKey, user, projectCategory));
    }

    public Collection<Project> getArchivedProjects(@Nonnull ProjectPermissionKey permissionKey, @Nullable ApplicationUser user) {
        return this.checkUserHasApplicationOrEmpty(user, permissionKey, () -> this.permissionManager.getArchivedProjects(permissionKey, user));
    }

    public void flushCache() {
        this.permissionManager.flushCache();
    }

    public Collection<Group> getAllGroups(int permissionId, Project project) {
        return this.permissionManager.getAllGroups(permissionId, project);
    }

    private ApplicationRoleManager applicationRoleManager() {
        return (ApplicationRoleManager)ComponentAccessor.getComponent(ApplicationRoleManager.class);
    }

    private boolean checkUserHasApplicationOrFalse(ApplicationUser user, int permissionId, BooleanSupplier delegate) {
        return this.checkUserHasApplicationOrFalse(user, LegacyProjectPermissionKeyMapping.getKey(permissionId), delegate);
    }

    private boolean checkUserHasApplicationOrFalse(ApplicationUser user, ProjectPermissionKey permissionKey, BooleanSupplier delegate) {
        return this.shouldUserHaveAccess(user, permissionKey) && delegate.getAsBoolean();
    }

    private Collection<Project> checkUserHasApplicationOrEmpty(ApplicationUser user, ProjectPermissionKey permissionKey, Supplier<Collection<Project>> delegate) {
        return this.checkUserHasApplicationOrElse(user, permissionKey, delegate, ImmutableList::of);
    }

    private <T> T checkUserHasApplicationOrElse(ApplicationUser user, ProjectPermissionKey permissionKey, Supplier<T> application, Supplier<? extends T> noApplication) {
        if (this.shouldUserHaveAccess(user, permissionKey)) {
            return application.get();
        }
        return noApplication.get();
    }

    private boolean shouldUserHaveAccess(ApplicationUser user, ProjectPermissionKey permissionKey) {
        GlobalPermissionManager globalPermissions = ComponentAccessor.getGlobalPermissionManager();
        ApplicationRoleManager roleManager = this.applicationRoleManager();
        boolean hasApplicationAccess = roleManager.hasAnyRole(user);
        return hasApplicationAccess || !globalPermissions.hasPermission(GlobalPermissionKey.ADMINISTER, user) && this.isNotBlockedPermission(permissionKey);
    }

    private boolean isNotBlockedPermission(ProjectPermissionKey key) {
        return !blockedPermissions.contains(key);
    }
}

