/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security;

import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.exception.RemoveException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.security.IssueSecuritySchemeManager;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.permission.LegacyProjectPermissionKeyMapping;
import com.atlassian.jira.permission.PermissionSchemeManager;
import com.atlassian.jira.permission.ProjectPermission;
import com.atlassian.jira.permission.ProjectPermissionCategory;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectCategory;
import com.atlassian.jira.security.HeuristicalProjectPermissionChecker;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.Permissions;
import com.atlassian.jira.security.ProjectPermissionOverrideDescriptorCache;
import com.atlassian.jira.security.ProjectWidePermission;
import com.atlassian.jira.security.plugin.ProjectPermissionKey;
import com.atlassian.jira.security.plugin.ProjectPermissionOverride;
import com.atlassian.jira.security.plugin.ProjectPermissionOverrideModuleDescriptor;
import com.atlassian.jira.security.plugin.ProjectPermissionTypesManager;
import com.atlassian.jira.security.plugin.ScopesRequestCacheDelegate;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.ozymandias.SafePluginPointAccess;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.opensymphony.workflow.loader.ActionDescriptor;
import io.atlassian.fugue.Option;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPermissionManager
implements PermissionManager {
    private static final Logger log = LoggerFactory.getLogger(DefaultPermissionManager.class);
    private static final Set<ProjectPermissionKey> SECURITY_LEVEL_AFFECTED_PERMISSIONS = ImmutableSet.of((Object)ProjectPermissions.BROWSE_PROJECTS, (Object)ProjectPermissions.EDIT_ISSUES, (Object)ProjectPermissions.TRANSITION_ISSUES, (Object)ProjectPermissions.SCHEDULE_ISSUES, (Object)ProjectPermissions.MOVE_ISSUES, (Object)ProjectPermissions.ASSIGN_ISSUES, (Object[])new ProjectPermissionKey[]{ProjectPermissions.RESOLVE_ISSUES, ProjectPermissions.CLOSE_ISSUES, ProjectPermissions.LINK_ISSUES, ProjectPermissions.MODIFY_REPORTER, ProjectPermissions.DELETE_ISSUES, ProjectPermissions.ARCHIVE_ISSUES, ProjectPermissions.RESTORE_ISSUES, ProjectPermissions.BROWSE_ARCHIVE, ProjectPermissions.ADD_COMMENTS, ProjectPermissions.EDIT_ALL_COMMENTS, ProjectPermissions.EDIT_OWN_COMMENTS, ProjectPermissions.DELETE_ALL_COMMENTS, ProjectPermissions.DELETE_OWN_COMMENTS, ProjectPermissions.WORK_ON_ISSUES, ProjectPermissions.EDIT_ALL_WORKLOGS, ProjectPermissions.EDIT_OWN_WORKLOGS, ProjectPermissions.DELETE_ALL_WORKLOGS, ProjectPermissions.DELETE_OWN_WORKLOGS, ProjectPermissions.CREATE_ATTACHMENTS, ProjectPermissions.DELETE_ALL_ATTACHMENTS, ProjectPermissions.DELETE_OWN_ATTACHMENTS, ProjectPermissions.VIEW_VOTERS_AND_WATCHERS, ProjectPermissions.MANAGE_WATCHERS, ProjectPermissions.SET_ISSUE_SECURITY});
    private final ProjectPermissionTypesManager projectPermissionTypesManager;
    private final ProjectPermissionOverrideDescriptorCache projectPermissionOverrideDescriptorCache;
    private final ScopesRequestCacheDelegate scopesRequestCacheDelegate;
    private final HeuristicalProjectPermissionChecker heuristicalProjectPermissionChecker = new HeuristicalProjectPermissionChecker(this);

    public DefaultPermissionManager(ProjectPermissionTypesManager projectPermissionTypesManager, ProjectPermissionOverrideDescriptorCache projectPermissionOverrideDescriptorCache, ScopesRequestCacheDelegate scopesRequestCacheDelegate) {
        this.projectPermissionTypesManager = projectPermissionTypesManager;
        this.projectPermissionOverrideDescriptorCache = projectPermissionOverrideDescriptorCache;
        this.scopesRequestCacheDelegate = scopesRequestCacheDelegate;
    }

    public Collection<ProjectPermission> getAllProjectPermissions() {
        return this.projectPermissionTypesManager.all();
    }

    public Collection<ProjectPermission> getProjectPermissions(@Nonnull ProjectPermissionCategory category) {
        return this.projectPermissionTypesManager.withCategory(category);
    }

    public Option<ProjectPermission> getProjectPermission(@Nonnull ProjectPermissionKey permissionKey) {
        return this.projectPermissionTypesManager.withKey(permissionKey);
    }

    public boolean hasPermission(int permissionsId, ApplicationUser user) {
        if (!this.isGlobalPermission(permissionsId)) {
            throw new IllegalArgumentException("Expected global permission, got " + permissionsId);
        }
        if (user == null) {
            return ComponentAccessor.getGlobalPermissionManager().hasPermission(permissionsId);
        }
        return user.isActive() && ComponentAccessor.getGlobalPermissionManager().hasPermission(permissionsId, user);
    }

    public boolean hasPermission(@Nonnull ProjectPermissionKey permissionKey, @Nonnull Issue issue, @Nullable ApplicationUser user) {
        return this.withPermissionOverriding(this.doIssuePermissionCheck(permissionKey, issue, user), permissionKey, issue.getProjectObject(), user);
    }

    public boolean hasPermission(@Nonnull ProjectPermissionKey permissionKey, @Nonnull Issue issue, @Nullable ApplicationUser user, @Nullable ActionDescriptor actionDescriptor) {
        throw new UnsupportedOperationException();
    }

    public boolean hasPermission(@Nonnull ProjectPermissionKey permissionKey, @Nonnull Issue issue, @Nullable ApplicationUser user, @Nonnull Status status) {
        throw new UnsupportedOperationException();
    }

    public boolean hasPermission(int permissionsId, Issue issue, ApplicationUser user) {
        ProjectPermissionKey permissionKey = this.getNonGlobalKey(permissionsId);
        return this.hasPermission(permissionKey, issue, user);
    }

    public boolean hasPermission(@Nonnull ProjectPermissionKey permissionKey, @Nonnull Project project, @Nullable ApplicationUser user) {
        return this.withPermissionOverriding(this.doProjectPermissionCheck(permissionKey, project, user, false), permissionKey, project, user);
    }

    public boolean hasPermission(int permissionsId, Project project, ApplicationUser user) {
        ProjectPermissionKey permissionKey = this.getNonGlobalKey(permissionsId);
        return this.hasPermission(permissionKey, project, user);
    }

    @Nonnull
    public ProjectWidePermission hasProjectWidePermission(@Nonnull ProjectPermissionKey permissionKey, @Nonnull Project project, @Nullable ApplicationUser user) {
        ProjectWidePermission corePermissionCheckResult = this.doProjectWidePermissionCheck(permissionKey, project, user, false);
        return this.withPermissionOverriding(corePermissionCheckResult, permissionKey, project, user);
    }

    public boolean hasPermission(int permissionsId, Project project, ApplicationUser user, boolean issueCreation) {
        ProjectPermissionKey permissionKey = this.getNonGlobalKey(permissionsId);
        return this.hasPermission(permissionKey, project, user, issueCreation);
    }

    public boolean hasPermission(@Nonnull ProjectPermissionKey permissionKey, @Nonnull Project project, @Nullable ApplicationUser user, boolean issueCreation) {
        return this.withPermissionOverriding(this.doProjectPermissionCheck(permissionKey, project, user, issueCreation), permissionKey, project, user);
    }

    private boolean doIssuePermissionCheck(ProjectPermissionKey permissionKey, Issue issue, ApplicationUser user) {
        if (!this.scopesRequestCacheDelegate.hasPermission(permissionKey)) {
            return false;
        }
        if (issue.getId() != null) {
            return this.doIssuePermissionCheck(permissionKey, issue, user, false);
        }
        return this.doProjectPermissionCheck(permissionKey, issue.getProjectObject(), user, true);
    }

    private boolean doIssuePermissionCheck(ProjectPermissionKey permissionKey, Issue issue, ApplicationUser user, boolean issueCreation) {
        if (!this.doArchivedIssuePermissionCheck(permissionKey, issue)) {
            return false;
        }
        if (!this.doProjectPermissionCheck(permissionKey, issue.getProjectObject(), user, false)) {
            return false;
        }
        if (!this.doPermissionSchemeCheck(permissionKey, issue, user, issueCreation)) {
            return false;
        }
        if (SECURITY_LEVEL_AFFECTED_PERMISSIONS.contains(permissionKey)) {
            return ((IssueSecuritySchemeManager)ComponentAccessor.getComponent(IssueSecuritySchemeManager.class)).hasSecurityLevelAccess(issue, user);
        }
        return true;
    }

    private boolean doArchivedIssuePermissionCheck(ProjectPermissionKey permissionKey, Issue issue) {
        return !issue.isArchived() || (Boolean)this.getProjectPermission(permissionKey).map(ProjectPermission::isAvailableForArchivedEntities).getOrElse((Object)false) != false;
    }

    private boolean doPermissionSchemeCheck(ProjectPermissionKey permissionKey, Issue issue, ApplicationUser user, boolean issueCreation) {
        if (!this.projectPermissionTypesManager.exists(permissionKey)) {
            return false;
        }
        if (user == null) {
            return ComponentAccessor.getPermissionSchemeManager().hasSchemePermission(permissionKey, issue);
        }
        return user.isActive() && ComponentAccessor.getPermissionSchemeManager().hasSchemePermission(permissionKey, issue, user, issueCreation);
    }

    private boolean doProjectPermissionCheck(@Nonnull ProjectPermissionKey permissionKey, Project project, @Nullable ApplicationUser user, boolean issueCreation) {
        if (!this.scopesRequestCacheDelegate.hasPermission(permissionKey)) {
            return false;
        }
        if (project == null || project.getId() == null) {
            throw new IllegalArgumentException("The Project argument and its backing generic value must not be null");
        }
        if (!this.doArchivedProjectCheck(permissionKey, project)) {
            return false;
        }
        if (!this.projectPermissionTypesManager.exists(permissionKey)) {
            return false;
        }
        PermissionSchemeManager permissionSchemeManager = ComponentAccessor.getPermissionSchemeManager();
        if (user == null) {
            return permissionSchemeManager.hasSchemePermission(permissionKey, project);
        }
        return user.isActive() && permissionSchemeManager.hasSchemePermission(permissionKey, project, user, issueCreation);
    }

    private boolean doArchivedProjectCheck(@Nonnull ProjectPermissionKey permissionKey, @Nonnull Project project) {
        return !project.isArchived() || (Boolean)this.getProjectPermission(permissionKey).map(ProjectPermission::isAvailableForArchivedEntities).getOrElse((Object)false) != false;
    }

    private ProjectWidePermission doProjectWidePermissionCheck(@Nonnull ProjectPermissionKey permissionKey, Project project, @Nullable ApplicationUser user, boolean issueCreation) {
        if (!this.scopesRequestCacheDelegate.hasPermission(permissionKey)) {
            return ProjectWidePermission.NO_ISSUES;
        }
        if (project == null || project.getId() == null) {
            throw new IllegalArgumentException("The Project argument and its backing generic value must not be null");
        }
        if (!this.projectPermissionTypesManager.exists(permissionKey)) {
            return ProjectWidePermission.NO_ISSUES;
        }
        if (user == null) {
            return ComponentAccessor.getPermissionSchemeManager().hasSchemePermission(permissionKey, project) ? ProjectWidePermission.ALL_ISSUES : ProjectWidePermission.NO_ISSUES;
        }
        if (user.isActive()) {
            return ComponentAccessor.getPermissionSchemeManager().hasProjectWidePermission(permissionKey, project, user, issueCreation);
        }
        return ProjectWidePermission.NO_ISSUES;
    }

    public void removeGroupPermissions(String group) throws RemoveException {
        Assertions.notNull((String)"group", (Object)group);
        Assertions.notNull((Object)ComponentAccessor.getGroupManager().getGroup(group));
        ComponentAccessor.getGlobalPermissionManager().removePermissions(group);
        ComponentAccessor.getPermissionSchemeManager().removeEntities("group", group);
        ((IssueSecuritySchemeManager)ComponentAccessor.getComponent(IssueSecuritySchemeManager.class)).removeEntities("group", group);
    }

    public void removeUserPermissions(ApplicationUser user) throws RemoveException {
        Assertions.notNull((String)"user", (Object)user);
        ComponentAccessor.getPermissionSchemeManager().removeEntities("user", user.getKey());
        ((IssueSecuritySchemeManager)ComponentAccessor.getComponent(IssueSecuritySchemeManager.class)).removeEntities("user", user.getKey());
    }

    public boolean hasProjects(int permissionId, ApplicationUser user) {
        ProjectPermissionKey permissionKey = this.getNonGlobalKey(permissionId);
        return this.hasProjects(permissionKey, user);
    }

    public boolean hasProjects(@Nonnull ProjectPermissionKey permissionKey, @Nullable ApplicationUser user) {
        if (!this.projectPermissionTypesManager.exists(permissionKey) || !this.scopesRequestCacheDelegate.hasPermission(permissionKey)) {
            return false;
        }
        return this.heuristicalProjectPermissionChecker.findAnyProject(permissionKey, user).isPresent();
    }

    public Collection<Project> getProjects(@Nonnull ProjectPermissionKey permissionKey, ApplicationUser user) {
        return this.getProjectObjects(permissionKey, user);
    }

    protected Collection<Project> getProjectObjects(ProjectPermissionKey permissionKey, ApplicationUser user) {
        return this.getProjectObjectsWithPermission(ComponentAccessor.getProjectManager().getProjectObjects(), permissionKey, user);
    }

    public Collection<Project> getProjects(int permissionId, ApplicationUser user, ProjectCategory projectCategory) {
        ProjectPermissionKey permissionKey = this.getNonGlobalKey(permissionId);
        return this.getProjects(permissionKey, user, projectCategory);
    }

    public Collection<Project> getProjects(@Nonnull ProjectPermissionKey permissionKey, @Nullable ApplicationUser user, @Nullable ProjectCategory projectCategory) {
        Collection projects = projectCategory == null ? ComponentAccessor.getProjectManager().getProjectObjectsWithNoCategory() : ComponentAccessor.getProjectManager().getProjectsFromProjectCategory(projectCategory);
        return this.getProjectObjectsWithPermission(projects, permissionKey, user);
    }

    public Collection<Project> getArchivedProjects(@Nonnull ProjectPermissionKey permissionKey, ApplicationUser user) {
        return this.getArchivedProjectObjects(permissionKey, user);
    }

    protected Collection<Project> getArchivedProjectObjects(ProjectPermissionKey permissionKey, ApplicationUser user) {
        return this.getProjectObjectsWithPermission(ComponentAccessor.getProjectManager().getArchivedProjects(), permissionKey, user);
    }

    public void flushCache() {
    }

    private Collection<Project> getProjectObjectsWithPermission(Collection<Project> projects, ProjectPermissionKey permissionKey, ApplicationUser user) {
        if (!this.projectPermissionTypesManager.exists(permissionKey) || !this.scopesRequestCacheDelegate.hasPermission(permissionKey)) {
            return Collections.emptyList();
        }
        return projects.stream().filter(project -> this.hasPermission(permissionKey, (Project)project, user)).collect(Collectors.toCollection(ArrayList::new));
    }

    private ProjectPermissionKey getNonGlobalKey(int permissionId) {
        if (this.isGlobalPermission(permissionId)) {
            throw new IllegalArgumentException("PermissionType passed to this function must NOT be a global permission, " + permissionId + " is global");
        }
        return LegacyProjectPermissionKeyMapping.getKey(permissionId);
    }

    protected boolean isGlobalPermission(int permissionId) {
        return Permissions.isGlobalPermission((int)permissionId);
    }

    public Collection<Group> getAllGroups(int permissionId, Project project) {
        HashSet<Group> groups = new HashSet<Group>();
        groups.addAll(ComponentAccessor.getPermissionSchemeManager().getGroups(new ProjectPermissionKey(permissionId), project));
        groups.addAll(ComponentAccessor.getGlobalPermissionManager().getGroupsWithPermission(permissionId));
        return groups;
    }

    private ProjectWidePermission withPermissionOverriding(ProjectWidePermission corePermissionCheckResult, final ProjectPermissionKey permissionKey, final Project project, final ApplicationUser applicationUser) {
        if (corePermissionCheckResult == ProjectWidePermission.NO_ISSUES || ProjectPermissions.BROWSE_PROJECTS.equals((Object)permissionKey)) {
            return corePermissionCheckResult;
        }
        boolean pluginPermissionCheckDeclined = Iterables.any(this.projectPermissionOverrideDescriptorCache.getProjectPermissionOverrideDescriptors(), (com.google.common.base.Predicate)new com.google.common.base.Predicate<ProjectPermissionOverrideModuleDescriptor>(){

            public boolean apply(ProjectPermissionOverrideModuleDescriptor permissionOverrideModuleDescriptor) {
                return SafePluginPointAccess.safe((Predicate)new com.google.common.base.Predicate<ProjectPermissionOverrideModuleDescriptor>(){

                    public boolean apply(ProjectPermissionOverrideModuleDescriptor permissionOverrideModuleDescriptor) {
                        ProjectPermissionOverride.Decision decision = ((ProjectPermissionOverride)permissionOverrideModuleDescriptor.getModule()).hasPermission(permissionKey, project, applicationUser);
                        if (log.isDebugEnabled() && decision == ProjectPermissionOverride.Decision.DENY) {
                            log.debug("Permission check result to project " + project.getKey() + "was overriden by " + permissionOverrideModuleDescriptor.getCompleteKey());
                        }
                        return decision == ProjectPermissionOverride.Decision.DENY;
                    }
                }).test(permissionOverrideModuleDescriptor);
            }
        });
        if (pluginPermissionCheckDeclined) {
            return ProjectWidePermission.NO_ISSUES;
        }
        return corePermissionCheckResult;
    }

    private boolean withPermissionOverriding(boolean corePermissionCheckResult, final ProjectPermissionKey permissionKey, final Project project, final ApplicationUser applicationUser) {
        if (!corePermissionCheckResult || ProjectPermissions.BROWSE_PROJECTS.equals((Object)permissionKey)) {
            return corePermissionCheckResult;
        }
        Boolean pluginPermissionCheckDeclined = (Boolean)MoreObjects.firstNonNull((Object)Iterables.any(this.projectPermissionOverrideDescriptorCache.getProjectPermissionOverrideDescriptors(), permissionOverrideModuleDescriptor -> SafePluginPointAccess.safe((Predicate)new com.google.common.base.Predicate<ProjectPermissionOverrideModuleDescriptor>(){

            public boolean apply(ProjectPermissionOverrideModuleDescriptor permissionOverrideModuleDescriptor) {
                ProjectPermissionOverride.Decision decision = ((ProjectPermissionOverride)permissionOverrideModuleDescriptor.getModule()).hasPermission(permissionKey, project, applicationUser);
                if (log.isDebugEnabled() && decision == ProjectPermissionOverride.Decision.DENY) {
                    log.debug("Permission check result to project " + project.getKey() + "was overriden by " + permissionOverrideModuleDescriptor.getCompleteKey());
                }
                return decision == ProjectPermissionOverride.Decision.DENY;
            }
        }).test(permissionOverrideModuleDescriptor)), (Object)false);
        return pluginPermissionCheckDeclined == false;
    }
}

