/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security;

import com.atlassian.core.util.ClassLoaderUtils;
import com.atlassian.jira.security.BlocklistDeserializationFilter;
import com.atlassian.jira.security.filter.DeserializationFilterConfigurator;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputFilter;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesBasedDeserializationFilterConfigurator
implements DeserializationFilterConfigurator {
    private static final String BLOCKLIST_PROPERTIES_FILE = "deserialization-blocklist.properties";
    private static final Logger log = LoggerFactory.getLogger(PropertiesBasedDeserializationFilterConfigurator.class);

    @Override
    public void configureSerialFilter() {
        try {
            BlocklistDeserializationFilter deserializationFilter = new BlocklistDeserializationFilter(this.getBlockedClassesFromFile());
            ObjectInputFilter.Config.setSerialFilter(deserializationFilter);
            if (this.getCurrentSerialFilterClass() == null) {
                String url = "https://confluence.atlassian.com/adminjiraserver/live-monitoring-using-the-jmx-interface-939707304.html";
                throw new RuntimeException("BlocklistDeserializationFilter has not been set up, please check: " + url);
            }
            log.info("BlocklistDeserializationFilter successfully registered");
        }
        catch (IllegalStateException e) {
            log.error("Could not to create serial filter because it is already set. The current filter is based on this class: {}", this.getCurrentSerialFilterClass());
            throw new IllegalStateException("Serial filter can only be set once. Error: " + e.getMessage(), e);
        }
    }

    private Set<String> getBlockedClassesFromFile() {
        Set<String> set;
        block8: {
            InputStream blocklistPropertyFile = ClassLoaderUtils.getResourceAsStream((String)BLOCKLIST_PROPERTIES_FILE, this.getClass());
            try {
                set = this.readBlockedClasses(blocklistPropertyFile);
                if (blocklistPropertyFile == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (blocklistPropertyFile != null) {
                        try {
                            blocklistPropertyFile.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    log.error("Could not load default properties from '{}'. Deserialization filtering is disabled. {}", (Object)BLOCKLIST_PROPERTIES_FILE, (Object)e);
                    return Collections.emptySet();
                }
            }
            blocklistPropertyFile.close();
        }
        return set;
    }

    private Set<String> readBlockedClasses(InputStream blocklistPropertyFile) {
        return new BufferedReader(new InputStreamReader(blocklistPropertyFile)).lines().filter(listedClass -> StringUtils.isNotBlank((CharSequence)listedClass) && !listedClass.startsWith("#")).collect(Collectors.toSet());
    }

    private Class<?> getCurrentSerialFilterClass() {
        ObjectInputFilter currentSerialFilter = ObjectInputFilter.Config.getSerialFilter();
        return currentSerialFilter == null ? null : currentSerialFilter.getClass();
    }
}

