/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security;

import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.jira.config.FeatureFlag;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.exception.RemoveException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.permission.ProjectPermission;
import com.atlassian.jira.permission.ProjectPermissionCategory;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectCategory;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.ProjectWidePermission;
import com.atlassian.jira.security.plugin.ProjectPermissionKey;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.collect.ImmutableList;
import com.opensymphony.workflow.loader.ActionDescriptor;
import io.atlassian.fugue.Option;
import java.util.Collection;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class PublicAccessPermissionManager
implements PermissionManager {
    public static final FeatureFlag PUBLIC_ACCESS = FeatureFlag.featureFlag((String)"public.access").onByDefault();
    private final PermissionManager permissionManager;
    private final FeatureManager featureManager;

    public PublicAccessPermissionManager(PermissionManager permissionManager, FeatureManager featureManager) {
        this.permissionManager = (PermissionManager)Assertions.notNull((String)"permissionManager", (Object)permissionManager);
        this.featureManager = featureManager;
    }

    public Collection<ProjectPermission> getAllProjectPermissions() {
        return this.permissionManager.getAllProjectPermissions();
    }

    public Collection<ProjectPermission> getProjectPermissions(@Nonnull ProjectPermissionCategory category) {
        return this.permissionManager.getProjectPermissions(category);
    }

    @Deprecated
    public boolean hasPermission(int permissionsId, ApplicationUser user) {
        return this.permissionManager.hasPermission(permissionsId, user);
    }

    public Option<ProjectPermission> getProjectPermission(@Nonnull ProjectPermissionKey permissionKey) {
        return this.permissionManager.getProjectPermission(permissionKey);
    }

    @Deprecated
    public boolean hasPermission(int permissionsId, Issue issue, ApplicationUser user) {
        return this.checkPublicAccessEnabledOrDelegate(user, () -> this.permissionManager.hasPermission(permissionsId, issue, user));
    }

    public boolean hasPermission(@Nonnull ProjectPermissionKey permissionKey, @Nonnull Issue issue, @Nullable ApplicationUser user) {
        return this.checkPublicAccessEnabledOrDelegate(user, () -> this.permissionManager.hasPermission(permissionKey, issue, user));
    }

    public boolean hasPermission(@Nonnull ProjectPermissionKey permissionKey, @Nonnull Issue issue, @Nullable ApplicationUser user, @Nullable ActionDescriptor actionDescriptor) {
        return this.checkPublicAccessEnabledOrDelegate(user, () -> this.permissionManager.hasPermission(permissionKey, issue, user, actionDescriptor));
    }

    public boolean hasPermission(@Nonnull ProjectPermissionKey permissionKey, @Nonnull Issue issue, @Nullable ApplicationUser user, @Nonnull Status status) {
        return this.checkPublicAccessEnabledOrDelegate(user, () -> this.permissionManager.hasPermission(permissionKey, issue, user, status));
    }

    @Deprecated
    public boolean hasPermission(int permissionsId, Project project, ApplicationUser user) {
        return this.checkPublicAccessEnabledOrDelegate(user, () -> this.permissionManager.hasPermission(permissionsId, project, user));
    }

    public boolean hasPermission(@Nonnull ProjectPermissionKey permissionKey, @Nonnull Project project, @Nullable ApplicationUser user) {
        return this.checkPublicAccessEnabledOrDelegate(user, () -> this.permissionManager.hasPermission(permissionKey, project, user));
    }

    @Nonnull
    public ProjectWidePermission hasProjectWidePermission(@Nonnull ProjectPermissionKey permissionKey, @Nonnull Project project, @Nullable ApplicationUser user) {
        return this.checkPublicAccessEnabledOrElse(user, () -> this.permissionManager.hasProjectWidePermission(permissionKey, project, user), () -> ProjectWidePermission.NO_ISSUES);
    }

    @Deprecated
    public boolean hasPermission(int permissionsId, Project project, ApplicationUser user, boolean issueCreation) {
        return this.checkPublicAccessEnabledOrDelegate(user, () -> this.permissionManager.hasPermission(permissionsId, project, user, issueCreation));
    }

    public boolean hasPermission(@Nonnull ProjectPermissionKey permissionKey, @Nonnull Project project, @Nullable ApplicationUser user, boolean issueCreation) {
        return this.checkPublicAccessEnabledOrDelegate(user, () -> this.permissionManager.hasPermission(permissionKey, project, user, issueCreation));
    }

    public void removeGroupPermissions(String group) throws RemoveException {
        this.permissionManager.removeGroupPermissions(group);
    }

    public void removeUserPermissions(ApplicationUser user) throws RemoveException {
        this.permissionManager.removeUserPermissions(user);
    }

    @Deprecated
    public boolean hasProjects(int permissionId, ApplicationUser user) {
        return this.checkPublicAccessEnabledOrDelegate(user, () -> this.permissionManager.hasProjects(permissionId, user));
    }

    public boolean hasProjects(@Nonnull ProjectPermissionKey permissionKey, @Nullable ApplicationUser user) {
        return this.checkPublicAccessEnabledOrDelegate(user, () -> this.permissionManager.hasProjects(permissionKey, user));
    }

    public Collection<Project> getProjects(@Nonnull ProjectPermissionKey permissionKey, @Nullable ApplicationUser user) {
        return this.checkPublicAccessEnabledOrEmpty(user, () -> this.permissionManager.getProjects(permissionKey, user));
    }

    public Collection<Project> getProjects(@Nonnull ProjectPermissionKey permissionKey, @Nullable ApplicationUser user, @Nullable ProjectCategory projectCategory) {
        return this.checkPublicAccessEnabledOrEmpty(user, () -> this.permissionManager.getProjects(permissionKey, user, projectCategory));
    }

    public Collection<Project> getArchivedProjects(@Nonnull ProjectPermissionKey permissionKey, @Nullable ApplicationUser user) {
        return this.checkPublicAccessEnabledOrEmpty(user, () -> this.permissionManager.getArchivedProjects(permissionKey, user));
    }

    public void flushCache() {
        this.permissionManager.flushCache();
    }

    public Collection<Group> getAllGroups(int permissionId, Project project) {
        return this.permissionManager.getAllGroups(permissionId, project);
    }

    public boolean hasPublicAccess(@Nullable ApplicationUser applicationUser) {
        return this.checkPublicAccessEnabledOrDelegate(applicationUser, () -> true);
    }

    private boolean checkPublicAccessEnabledOrDelegate(ApplicationUser user, BooleanSupplier delegate) {
        if (user == null) {
            boolean isPublicAccessEnabled = this.featureManager.isEnabled(PUBLIC_ACCESS);
            return isPublicAccessEnabled && delegate.getAsBoolean();
        }
        return delegate.getAsBoolean();
    }

    private Collection<Project> checkPublicAccessEnabledOrEmpty(ApplicationUser user, Supplier<Collection<Project>> delegate) {
        return this.checkPublicAccessEnabledOrElse(user, delegate, ImmutableList::of);
    }

    private <T> T checkPublicAccessEnabledOrElse(ApplicationUser user, Supplier<T> projectPermissionSupplier, Supplier<? extends T> noPublicAccess) {
        if (user == null && !this.featureManager.isEnabled(PUBLIC_ACCESS)) {
            return noPublicAccess.get();
        }
        return projectPermissionSupplier.get();
    }
}

