/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security.annotated;

import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.security.annotated.ComponentsAvailabilityCheck;
import com.atlassian.jira.security.annotated.EmptyAccessTypeToDefault;
import com.atlassian.jira.security.annotated.PermissionCheck;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.core.permission.AccessType;
import com.google.common.annotations.VisibleForTesting;
import javax.annotation.Nullable;

public class AnnotatedSecurityChecker {
    private final ComponentsAvailabilityCheck componentsAvailabilityCheck;
    private final EmptyAccessTypeToDefault emptyAccessTypeToDefault;
    private final PermissionCheck permissionCheck;

    public AnnotatedSecurityChecker(@Nullable UserManager userManager, @Nullable FeatureManager featureManager) {
        this(new ComponentsAvailabilityCheck(userManager, featureManager), new EmptyAccessTypeToDefault(featureManager), new PermissionCheck(userManager));
    }

    @VisibleForTesting
    AnnotatedSecurityChecker(ComponentsAvailabilityCheck componentsAvailabilityCheck, EmptyAccessTypeToDefault emptyAccessTypeToDefault, PermissionCheck permissionCheck) {
        this.componentsAvailabilityCheck = componentsAvailabilityCheck;
        this.emptyAccessTypeToDefault = emptyAccessTypeToDefault;
        this.permissionCheck = permissionCheck;
    }

    public boolean isAllowedFor(AccessType accessType) {
        if (this.permissionCheck.isOpenForEveryone(accessType)) {
            return true;
        }
        if (!this.componentsAvailabilityCheck.areComponentsAvailable()) {
            return false;
        }
        return this.permissionCheck.isUserAuthorizedForAccessType(this.emptyAccessTypeToDefault.emptyToDefault(accessType));
    }
}

