/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security.annotated;

import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.core.permission.AccessType;

class PermissionCheck {
    private final UserManager userManager;

    PermissionCheck(UserManager userManager) {
        this.userManager = userManager;
    }

    boolean isUserAuthorizedForAccessType(AccessType accessType) {
        UserKey userKey = this.userManager.getRemoteUserKey();
        switch (accessType) {
            case SYSTEM_ADMIN_ONLY: {
                return userKey != null && this.userManager.isSystemAdmin(userKey);
            }
            case ADMIN_ONLY: {
                return userKey != null && this.userManager.isAdmin(userKey);
            }
            case LICENSED_ONLY: {
                return userKey != null && this.userManager.isLicensed(userKey);
            }
            case UNLICENSED_SITE_ACCESS: {
                return userKey != null && (this.userManager.isLicensed(userKey) || this.userManager.isLimitedUnlicensedUser(userKey));
            }
            case ANONYMOUS_SITE_ACCESS: {
                return userKey == null && this.userManager.isAnonymousAccessEnabled() || userKey != null && (this.userManager.isLicensed(userKey) || this.userManager.isLimitedUnlicensedUser(userKey));
            }
        }
        throw new IllegalArgumentException("Unsupported access type: " + accessType);
    }

    boolean isOpenForEveryone(AccessType accessType) {
        return accessType == AccessType.UNRESTRICTED_ACCESS;
    }
}

