/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security.annotated;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.jira.util.stats.LongStats;
import com.atlassian.jira.util.stats.ManagedStats;
import com.atlassian.jira.util.stats.MutableLongStats;
import com.atlassian.jira.util.stats.NotifiesOnClose;
import com.atlassian.jira.util.stats.RequestAwareManagedStats;
import com.atlassian.jira.util.stats.RequestAwareStats;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import javax.annotation.Nullable;

public interface SecureDefaultsStats
extends ManagedStats,
RequestAwareStats,
NotifiesOnClose {
    public void filterAllowed(long var1);

    public void filterNotAllowed(long var1);

    public void servletAllowed(long var1);

    public void servletNotAllowed(long var1);

    public void actionAllowed(long var1);

    public void actionNotAllowed(long var1);

    public void pluginServletAllowed(long var1);

    public void pluginServletNotAllowed(long var1);

    public static class Data
    extends RequestAwareManagedStats
    implements SecureDefaultsStats {
        final AllowedNotAllowed filter = new AllowedNotAllowed();
        final AllowedNotAllowed servlet = new AllowedNotAllowed();
        final AllowedNotAllowed action = new AllowedNotAllowed();
        final AllowedNotAllowed pluginServlet = new AllowedNotAllowed();

        private static MutableLongStats newMicrosAccumulator() {
            return new MutableLongStats(new long[]{TimeUnit.MICROSECONDS.toMicros(100L), TimeUnit.MILLISECONDS.toMicros(1L), TimeUnit.MILLISECONDS.toMicros(10L)});
        }

        public String getStatsName() {
            return "SecureDefaultsStats";
        }

        public Optional<Long> getTotalMeasuredOperationsForStatsOverheadInMillis() {
            return Optional.of(Stream.of(this.filter, this.servlet, this.action, this.pluginServlet).flatMap(a -> Stream.of(a.allowedMicros, a.notAllowedMicros)).map(MutableLongStats::get).mapToLong(LongStats::sum).map(TimeUnit.MICROSECONDS::toMillis).sum());
        }

        @Override
        public void filterAllowed(long micros) {
            this.filter.allowedMicros.accept(micros);
            this.addToRequestMarkup(micros);
        }

        @Override
        public void filterNotAllowed(long micros) {
            this.filter.notAllowedMicros.accept(micros);
            this.addToRequestMarkup(micros);
        }

        @Override
        public void servletAllowed(long micros) {
            this.servlet.allowedMicros.accept(micros);
            this.addToRequestMarkup(micros);
        }

        @Override
        public void servletNotAllowed(long micros) {
            this.servlet.notAllowedMicros.accept(micros);
            this.addToRequestMarkup(micros);
        }

        @Override
        public void actionAllowed(long micros) {
            this.action.allowedMicros.accept(micros);
            this.addToRequestMarkup(micros);
        }

        @Override
        public void actionNotAllowed(long micros) {
            this.action.notAllowedMicros.accept(micros);
            this.addToRequestMarkup(micros);
        }

        @Override
        public void pluginServletAllowed(long micros) {
            this.pluginServlet.allowedMicros.accept(micros);
            this.addToRequestMarkup(micros);
        }

        @Override
        public void pluginServletNotAllowed(long micros) {
            this.pluginServlet.notAllowedMicros.accept(micros);
            this.addToRequestMarkup(micros);
        }

        static class AllowedNotAllowed {
            final MutableLongStats allowedMicros = Data.newMicrosAccumulator();
            final MutableLongStats notAllowedMicros = Data.newMicrosAccumulator();

            AllowedNotAllowed() {
            }
        }
    }

    @EventName(value="jira.secure.defaults.stats")
    public static class AnalyticsEvent
    extends com.atlassian.jira.analytics.AnalyticsEvent {
        public AnalyticsEvent(@Nullable Map<Object, Object> snapshot, @Nullable Map<Object, Object> total) {
            super(AnalyticsEvent.addDurationAsLong(snapshot), AnalyticsEvent.addDurationAsLong(total));
        }
    }
}

