/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security.auth.trustedapps;

import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CachedReference;
import com.atlassian.event.api.EventListener;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.security.auth.trustedapps.TrustedApplicationData;
import com.atlassian.jira.security.auth.trustedapps.TrustedApplicationStore;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

@EventComponent
public final class CachingTrustedApplicationStore
implements TrustedApplicationStore {
    private final TrustedApplicationStore delegate;
    private final CachedReference<TrustedApplications> cache;

    public CachingTrustedApplicationStore(TrustedApplicationStore delegate, CacheManager cacheManager) {
        this.delegate = delegate;
        this.cache = cacheManager.getCachedReference(this.getClass().getName() + ".cache", () -> new TrustedApplications(delegate.getAll()));
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.cache.reset();
    }

    @Override
    public Set<TrustedApplicationData> getAll() {
        return ((TrustedApplications)this.cache.get()).getAll();
    }

    @Override
    public TrustedApplicationData getByApplicationId(String applicationId) {
        return ((TrustedApplications)this.cache.get()).get(applicationId);
    }

    @Override
    public TrustedApplicationData getById(long id) {
        return ((TrustedApplications)this.cache.get()).get(id);
    }

    @Override
    public TrustedApplicationData store(TrustedApplicationData trustedApplicationData) {
        TrustedApplicationData result = this.delegate.store(trustedApplicationData);
        this.cache.reset();
        return result;
    }

    @Override
    public boolean delete(long id) {
        boolean result = this.delegate.delete(id);
        this.cache.reset();
        return result;
    }

    @Override
    public boolean delete(String applicationId) {
        boolean result = this.delegate.delete(applicationId);
        this.cache.reset();
        return result;
    }

    private static final class TrustedApplications {
        final Map<Long, TrustedApplicationData> byId;
        final Map<String, TrustedApplicationData> byAppId;

        TrustedApplications(Set<TrustedApplicationData> datas) {
            HashMap<Long, TrustedApplicationData> byId = new HashMap<Long, TrustedApplicationData>(datas.size());
            HashMap<String, TrustedApplicationData> byAppId = new HashMap<String, TrustedApplicationData>(datas.size());
            for (TrustedApplicationData data : datas) {
                byId.put(data.getId(), data);
                byAppId.put(data.getApplicationId(), data);
            }
            this.byId = Collections.unmodifiableMap(byId);
            this.byAppId = Collections.unmodifiableMap(byAppId);
        }

        TrustedApplicationData get(long id) {
            return this.byId.get(id);
        }

        TrustedApplicationData get(String applicationId) {
            return this.byAppId.get(applicationId);
        }

        Set<TrustedApplicationData> getAll() {
            return ImmutableSet.copyOf(this.byId.values());
        }
    }
}

