/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security.plugin;

import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.security.GlobalPermissionEntry;
import com.atlassian.jira.security.plugin.ProjectPermissionKey;
import com.atlassian.jira.security.plugin.ScopesRequestCacheDelegate;
import com.atlassian.oauth2.scopes.api.Permission;
import com.atlassian.oauth2.scopes.api.ScopesRequestCache;
import com.atlassian.plugin.osgi.container.OsgiContainerManager;
import io.atlassian.util.concurrent.ResettableLazyReference;
import java.util.Optional;
import org.osgi.util.tracker.ServiceTracker;

public class DefaultScopesRequestCacheDelegate
implements ScopesRequestCacheDelegate {
    private final ResettableLazyReference<ServiceTracker<ScopesRequestCache, ScopesRequestCache>> scopesRequestCacheServiceTracker;

    public DefaultScopesRequestCacheDelegate(final OsgiContainerManager osgiContainerManager) {
        this.scopesRequestCacheServiceTracker = new ResettableLazyReference<ServiceTracker<ScopesRequestCache, ScopesRequestCache>>(){

            protected ServiceTracker<ScopesRequestCache, ScopesRequestCache> create() {
                return osgiContainerManager.getServiceTracker(ScopesRequestCache.class.getName());
            }
        };
    }

    @Override
    public boolean hasPermission(GlobalPermissionKey permission) {
        return permission == null || this.getScopeRequestCache().map(scopesRequestCache -> scopesRequestCache.hasPermission(Permission.permission((String)permission.toString()))).orElse(true) != false;
    }

    @Override
    public boolean hasPermission(ProjectPermissionKey permission) {
        return permission == null || this.getScopeRequestCache().map(scopesRequestCache -> scopesRequestCache.hasPermission(Permission.permission((String)permission.toString()))).orElse(true) != false;
    }

    @Override
    public boolean hasPermission(GlobalPermissionEntry permission) {
        return permission == null || this.getScopeRequestCache().map(scopesRequestCache -> scopesRequestCache.hasPermission(Permission.permission((String)permission.getPermissionKey()))).orElse(true) != false;
    }

    @Override
    public Optional<String> getApplicationNameForRequest() {
        return this.getScopeRequestCache().flatMap(ScopesRequestCache::getApplicationNameForRequest);
    }

    @Override
    public ScopesRequestCache.RequestCache getRequestCache() {
        return this.getScopeRequestCache().map(ScopesRequestCache::getRequestCache).orElse(new ScopesRequestCache.RequestCache());
    }

    @Override
    public void setRequestCache(ScopesRequestCache.RequestCache requestCache) {
        this.getScopeRequestCache().ifPresent(scopesRequestCache -> scopesRequestCache.setRequestCache(requestCache));
    }

    @Override
    public void clearRequestCache() {
        this.getScopeRequestCache().ifPresent(ScopesRequestCache::clearRequestCache);
    }

    private Optional<ScopesRequestCache> getScopeRequestCache() {
        return Optional.ofNullable((ScopesRequestCache)((ServiceTracker)this.scopesRequestCacheServiceTracker.get()).getService());
    }
}

