/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security.plugin;

import com.atlassian.event.api.EventListener;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.extension.Startable;
import com.atlassian.jira.permission.ProjectPermission;
import com.atlassian.jira.permission.ProjectPermissionCategory;
import com.atlassian.jira.plugin.permission.ProjectPermissionModuleDescriptor;
import com.atlassian.jira.plugin.util.PluginModuleTrackerFactory;
import com.atlassian.jira.plugin.webfragment.DefaultWebFragmentContext;
import com.atlassian.jira.security.plugin.ProjectPermissionKey;
import com.atlassian.jira.security.plugin.ProjectPermissionTypesManager;
import com.atlassian.plugin.tracker.PluginModuleTracker;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.atlassian.fugue.Option;
import io.atlassian.util.concurrent.ResettableLazyReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;

@EventComponent
public class ProjectPermissionTypesManagerImpl
implements ProjectPermissionTypesManager,
Startable {
    private final ResettableLazyReference<Map<ProjectPermissionKey, ProjectPermission>> permissions;

    public ProjectPermissionTypesManagerImpl(PluginModuleTrackerFactory trackerFactory) {
        final PluginModuleTracker<ProjectPermission, ProjectPermissionModuleDescriptor> pluginModuleTracker = trackerFactory.create(ProjectPermissionModuleDescriptor.class, new ProjectPermissionModuleTrackerCustomizer());
        this.permissions = new ResettableLazyReference<Map<ProjectPermissionKey, ProjectPermission>>(){

            protected Map<ProjectPermissionKey, ProjectPermission> create() {
                ArrayList permissions = Lists.newArrayList((Iterable)pluginModuleTracker.getModules());
                Collections.sort(permissions, new ProjectPermissionComparator());
                LinkedHashMap keysToPermissions = Maps.newLinkedHashMap();
                for (ProjectPermission permission : permissions) {
                    keysToPermissions.put(new ProjectPermissionKey(permission.getKey()), permission);
                }
                return ImmutableMap.copyOf((Map)keysToPermissions);
            }
        };
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.reset();
    }

    public void start() {
        this.reset();
    }

    private void reset() {
        if (this.permissions != null) {
            this.permissions.reset();
        }
    }

    @Override
    public Collection<ProjectPermission> all() {
        return this.filterByCondition(((Map)this.permissions.get()).values());
    }

    @Override
    public Collection<ProjectPermission> withCategory(final ProjectPermissionCategory category) {
        return Lists.newArrayList((Iterable)Iterables.filter(this.all(), (Predicate)new Predicate<ProjectPermission>(){

            public boolean apply(ProjectPermission permission) {
                return category.equals((Object)permission.getCategory());
            }
        }));
    }

    @Override
    public Option<ProjectPermission> withKey(ProjectPermissionKey permissionKey) {
        ProjectPermission permission = (ProjectPermission)((Map)this.permissions.get()).get(permissionKey);
        if (permission != null && this.evaluateCondition(permission)) {
            return Option.some((Object)permission);
        }
        return Option.none();
    }

    @Override
    public boolean exists(ProjectPermissionKey permissionKey) {
        return this.withKey(permissionKey).isDefined();
    }

    private boolean evaluateCondition(ProjectPermission permission) {
        return this.evaluateCondition(permission, DefaultWebFragmentContext.get());
    }

    private boolean evaluateCondition(ProjectPermission permission, Map<String, Object> context) {
        return permission.getCondition().shouldDisplay(context);
    }

    private Collection<ProjectPermission> filterByCondition(Collection<ProjectPermission> all) {
        final Map context = DefaultWebFragmentContext.get();
        return Lists.newArrayList((Iterable)Iterables.filter(all, (Predicate)new Predicate<ProjectPermission>(){

            public boolean apply(ProjectPermission permission) {
                return ProjectPermissionTypesManagerImpl.this.evaluateCondition(permission, context);
            }
        }));
    }

    private class ProjectPermissionModuleTrackerCustomizer
    implements PluginModuleTracker.Customizer<ProjectPermission, ProjectPermissionModuleDescriptor> {
        private ProjectPermissionModuleTrackerCustomizer() {
        }

        public ProjectPermissionModuleDescriptor adding(ProjectPermissionModuleDescriptor descriptor) {
            ProjectPermissionTypesManagerImpl.this.reset();
            return descriptor;
        }

        public void removed(ProjectPermissionModuleDescriptor descriptor) {
            ProjectPermissionTypesManagerImpl.this.reset();
        }
    }

    private static class ProjectPermissionComparator
    implements Comparator<ProjectPermission> {
        private ProjectPermissionComparator() {
        }

        @Override
        public int compare(ProjectPermission projectPermission1, ProjectPermission projectPermission2) {
            return projectPermission1.getKey().compareTo(projectPermission2.getKey());
        }
    }
}

