/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security.roles;

import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.group.GroupConfigurable;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.roles.DefaultRoleActors;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.jira.security.roles.ProjectRoleActors;
import com.atlassian.jira.security.roles.ProjectRoleAndActorStore;
import com.atlassian.jira.security.roles.ProjectRoleComparator;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.util.profiling.Ticker;
import com.atlassian.util.profiling.Timers;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nonnull;

public class DefaultProjectRoleManager
implements ProjectRoleManager,
GroupConfigurable {
    private final ProjectRoleAndActorStore projectRoleAndActorStore;

    public DefaultProjectRoleManager(ProjectRoleAndActorStore projectRoleAndActorStore) {
        this.projectRoleAndActorStore = projectRoleAndActorStore;
    }

    public Collection<ProjectRole> getProjectRoles() {
        return this.projectRoleAndActorStore.getAllProjectRoles();
    }

    public Collection<ProjectRole> getProjectRoles(ApplicationUser user, Project project) {
        if (user == null) {
            return Collections.emptyList();
        }
        TreeSet<ProjectRole> associatedProjectRoles = new TreeSet<ProjectRole>(ProjectRoleComparator.COMPARATOR);
        Collection<ProjectRole> allProjectRoles = this.getProjectRoles();
        for (ProjectRole projectRole : allProjectRoles) {
            ProjectRoleActors projectRoleActors = this.getProjectRoleActors(projectRole, project);
            if (projectRoleActors == null || !projectRoleActors.contains(user)) continue;
            associatedProjectRoles.add(projectRole);
        }
        return associatedProjectRoles;
    }

    public ProjectRole getProjectRole(Long id) {
        return this.projectRoleAndActorStore.getProjectRole(id);
    }

    public ProjectRole getProjectRole(String name) {
        return this.projectRoleAndActorStore.getProjectRoleByName(Assertions.notBlank((String)"ProjectRole", (String)name));
    }

    public ProjectRole createRole(ProjectRole projectRole) {
        if (projectRole == null || projectRole.getName() == null) {
            throw new IllegalArgumentException("ProjectRole can not be created with a null name");
        }
        if (this.isRoleNameUnique(projectRole.getName())) {
            return this.projectRoleAndActorStore.addProjectRole(projectRole);
        }
        throw new IllegalArgumentException("A project role with the provided name: " + projectRole.getName() + ", already exists in the system.");
    }

    public boolean isRoleNameUnique(String name) {
        return !this.roleWithNameExists(name);
    }

    private boolean roleWithNameExists(String name) {
        return this.projectRoleAndActorStore.getAllProjectRoles().stream().anyMatch(projectRole -> projectRole.getName().equalsIgnoreCase(name));
    }

    public void deleteRole(ProjectRole projectRole) {
        this.projectRoleAndActorStore.deleteProjectRole((ProjectRole)Assertions.notNull((String)"ProjectRole", (Object)projectRole));
    }

    public void updateRole(ProjectRole projectRole) {
        if (projectRole == null) {
            throw new IllegalArgumentException("ProjectRole can not be null");
        }
        if (projectRole.getName() == null) {
            throw new IllegalArgumentException("ProjectRole name can not be null");
        }
        this.projectRoleAndActorStore.updateProjectRole(projectRole);
    }

    public ProjectRoleActors getProjectRoleActors(ProjectRole projectRole, Project project) {
        return this.projectRoleAndActorStore.getProjectRoleActors(((ProjectRole)Assertions.notNull((String)"ProjectRole", (Object)projectRole)).getId(), ((Project)Assertions.notNull((String)"Project", (Object)project)).getId());
    }

    public void updateProjectRoleActors(ProjectRoleActors projectRoleActors) {
        if (projectRoleActors == null) {
            throw new IllegalArgumentException("ProjectRoleActors can not be null");
        }
        if (projectRoleActors.getProjectId() == null) {
            throw new IllegalArgumentException("ProjectRoleActors project can not be null");
        }
        if (projectRoleActors.getProjectRoleId() == null) {
            throw new IllegalArgumentException("ProjectRoleActors projectRole can not be null");
        }
        if (projectRoleActors.getRoleActors() == null) {
            throw new IllegalArgumentException("ProjectRoleActors roleActors set can not be null");
        }
        this.projectRoleAndActorStore.updateProjectRoleActors(projectRoleActors);
    }

    public DefaultRoleActors getDefaultRoleActors(ProjectRole projectRole) {
        return this.projectRoleAndActorStore.getDefaultRoleActors(((ProjectRole)Assertions.notNull((String)"ProjectRole", (Object)projectRole)).getId());
    }

    public void updateDefaultRoleActors(DefaultRoleActors defaultRoleActors) {
        if (defaultRoleActors == null) {
            throw new IllegalArgumentException("DefaultRoleActors can not be null");
        }
        if (defaultRoleActors.getProjectRoleId() == null) {
            throw new IllegalArgumentException("DefaultRoleActors projectRole can not be null");
        }
        if (defaultRoleActors.getRoleActors() == null) {
            throw new IllegalArgumentException("DefaultRoleActors roleActors set can not be null");
        }
        this.projectRoleAndActorStore.updateDefaultRoleActors(defaultRoleActors);
    }

    public void applyDefaultsRolesToProject(Project project) {
        this.projectRoleAndActorStore.applyDefaultsRolesToProject((Project)Assertions.notNull((String)"Project", (Object)project));
    }

    public void removeAllRoleActorsByNameAndType(String key, String type) {
        this.projectRoleAndActorStore.removeAllRoleActorsByKeyAndType((String)Assertions.notNull((String)"role actor name", (Object)key), (String)Assertions.notNull((String)"role type", (Object)type));
    }

    public void removeAllRoleActorsByProject(Project project) {
        if (project == null || project.getId() == null) {
            throw new IllegalArgumentException("The project id can not be null");
        }
        this.projectRoleAndActorStore.removeAllRoleActorsByProject(project);
    }

    public boolean isUserInProjectRole(ApplicationUser user, ProjectRole projectRole, Project project) {
        try (Ticker ignored = Timers.start((String)"DefaultProjectRoleManager.isUserInProjectRole");){
            if (project == null || project.getId() == null) {
                throw new IllegalArgumentException("The project id can not be null");
            }
            if (projectRole == null) {
                throw new IllegalArgumentException("ProjectRole can not be null");
            }
            boolean bl = this.getProjectRoleActors(projectRole, project).contains(user);
            return bl;
        }
    }

    public Collection<Long> getProjectIdsContainingRoleActorByNameAndType(String key, String type) {
        return this.projectRoleAndActorStore.getProjectIdsContainingRoleActorByKeyAndType((String)Assertions.notNull((String)"role actor name", (Object)key), (String)Assertions.notNull((String)"role type", (Object)type));
    }

    public List<Long> roleActorOfTypeExistsForProjects(List<Long> projectsToLimitBy, ProjectRole projectRole, String projectRoleType, String projectRoleParameter) {
        return this.projectRoleAndActorStore.roleActorOfTypeExistsForProjects(projectsToLimitBy, projectRole, projectRoleType, projectRoleParameter);
    }

    public Map<Long, List<String>> getProjectIdsForUserInGroupsBecauseOfRole(List<Long> projectsToLimitBy, ProjectRole projectRole, String projectRoleType, String userName) {
        return this.projectRoleAndActorStore.getProjectIdsForUserInGroupsBecauseOfRole(projectsToLimitBy, projectRole, projectRoleType, userName);
    }

    @Deprecated
    public ProjectRoleManager.ProjectIdToProjectRoleIdsMap createProjectIdToProjectRolesMap(ApplicationUser user, Collection<Long> projectIds) {
        ProjectRoleManager.ProjectIdToProjectRoleIdsMap map = new ProjectRoleManager.ProjectIdToProjectRoleIdsMap();
        if (projectIds != null && !projectIds.isEmpty()) {
            ProjectManager projectManager = ComponentAccessor.getProjectManager();
            for (Long projectId : projectIds) {
                Collection<ProjectRole> projectRoles = this.getProjectRoles(user, projectManager.getProjectObj(projectId));
                for (ProjectRole projectRole : projectRoles) {
                    map.add(projectId, projectRole.getId());
                }
            }
        }
        return map;
    }

    public ProjectRoleManager.ProjectIdToProjectRoleIdsMap createProjectIdToProjectRolesMapWithGroups(@Nonnull ApplicationUser user, @Nonnull Set<String> groups) {
        ProjectRoleManager.ProjectIdToProjectRoleIdsMap aggregatedMap = new ProjectRoleManager.ProjectIdToProjectRoleIdsMap();
        this.addProjectIdToProjectRoleIdsMap(aggregatedMap, this.projectRoleAndActorStore.getProjectIdToRoleIds(user.getKey(), "atlassian-user-role-actor"));
        for (String group : groups) {
            this.addProjectIdToProjectRoleIdsMap(aggregatedMap, this.projectRoleAndActorStore.getProjectIdToRoleIds(group, "atlassian-group-role-actor"));
        }
        return aggregatedMap;
    }

    private void addProjectIdToProjectRoleIdsMap(ProjectRoleManager.ProjectIdToProjectRoleIdsMap aggregatedMap, ProjectRoleManager.ProjectIdToProjectRoleIdsMap mapToAdd) {
        if (!mapToAdd.isEmpty()) {
            for (ProjectRoleManager.ProjectIdToProjectRoleIdsMap.Entry entry : mapToAdd) {
                aggregatedMap.addList(entry.getProjectId(), entry.getProjectRoleIds());
            }
        }
    }

    @Override
    public boolean isGroupUsed(@Nonnull Group group) {
        return this.projectRoleAndActorStore.isGroupUsed(group.getName());
    }
}

