/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security.roles;

import com.atlassian.jira.security.roles.DefaultRoleActors;
import com.atlassian.jira.security.roles.DefaultRoleActorsImpl;
import com.atlassian.jira.security.roles.ProjectRoleActors;
import com.atlassian.jira.security.roles.RoleActor;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class ProjectRoleActorsImpl
extends DefaultRoleActorsImpl
implements ProjectRoleActors {
    private final Long projectId;

    public ProjectRoleActorsImpl(Long projectId, Long projectRoleId, Set<? extends RoleActor> roleActors) {
        super(projectRoleId, roleActors);
        this.projectId = projectId;
    }

    public ProjectRoleActorsImpl(Long projectId, Long projectRoleId, RoleActor roleActor) {
        super(projectRoleId, roleActor);
        this.projectId = projectId;
    }

    public Long getProjectId() {
        return this.projectId;
    }

    @Override
    public DefaultRoleActors addRoleActor(RoleActor roleActor) {
        HashSet set = Sets.newHashSet(this.getRoleActors());
        set.add(roleActor);
        return new ProjectRoleActorsImpl(this.projectId, this.getProjectRoleId(), set);
    }

    @Override
    public DefaultRoleActors addRoleActors(Collection<? extends RoleActor> roleActors) {
        HashSet set = Sets.newHashSet(this.getRoleActors());
        set.addAll(roleActors);
        return new ProjectRoleActorsImpl(this.projectId, this.getProjectRoleId(), set);
    }

    @Override
    public DefaultRoleActors removeRoleActor(RoleActor roleActor) {
        Set<RoleActor> roleActors = this.getRoleActors();
        if (!roleActors.contains(roleActor)) {
            return this;
        }
        HashSet set = Sets.newHashSet(roleActors);
        set.remove(roleActor);
        return new ProjectRoleActorsImpl(this.projectId, this.getProjectRoleId(), set);
    }

    @Override
    public DefaultRoleActors removeRoleActors(Collection<? extends RoleActor> roleActors) {
        HashSet set = Sets.newHashSet(this.getRoleActors());
        set.removeAll(roleActors);
        return new ProjectRoleActorsImpl(this.projectId, this.getProjectRoleId(), set);
    }

    @Override
    public String toString() {
        return "ProjectRoleActorsImpl[projectId=" + this.projectId + ",super=" + super.toString() + "]";
    }
}

