/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security.roles;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.event.api.EventListener;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.config.feature.OneWayDatabaseVersionFeature;
import com.atlassian.jira.config.properties.ApplicationPropertiesManager;
import com.atlassian.jira.config.properties.ApplicationProperty;
import com.atlassian.jira.event.JiraUpgradedEvent;
import com.atlassian.jira.security.roles.ProjectRoleAndActorStore;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.jira.util.Supplier;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EventComponent
public class RoleTypeMappingZduSafeCache {
    @VisibleForTesting
    public static final int JIRA_VERSION_WITH_FEATURE_ENABLED = 9130001;
    private static final Logger log = LoggerFactory.getLogger(RoleTypeMappingZduSafeCache.class);
    private final ProjectRoleAndActorStore delegate;
    private final Cache<ProjectRoleAndActorStore.RoleTypeMapping, ProjectRoleManager.ProjectIdToProjectRoleIdsMap> roleTypeMappingCache;
    private final OneWayDatabaseVersionFeature oneWayDatabaseVersionFeature;

    public RoleTypeMappingZduSafeCache(CacheManager cacheManager, ProjectRoleAndActorStore delegate, ApplicationPropertiesManager applicationPropertiesManager) {
        this.delegate = delegate;
        this.roleTypeMappingCache = cacheManager.getCache(RoleTypeMappingZduSafeCache.class.getName(), this::getProjectIdToProjectRoleIdsFromDelegate, new CacheSettingsBuilder().remote().replicateViaInvalidation().unflushable().build());
        this.oneWayDatabaseVersionFeature = new OneWayDatabaseVersionFeature(RoleTypeMappingZduSafeCache.class.getName(), null, 9130001, (Supplier<Integer>)((Supplier)() -> applicationPropertiesManager.get("jira.version.patched").map(ApplicationProperty::getString).map(Integer::parseInt).orElse(0)), this::removeAll);
    }

    public ProjectRoleManager.ProjectIdToProjectRoleIdsMap get(@Nonnull ProjectRoleAndActorStore.RoleTypeMapping key) {
        if (this.oneWayDatabaseVersionFeature.isFeatureEnabled()) {
            return (ProjectRoleManager.ProjectIdToProjectRoleIdsMap)this.roleTypeMappingCache.get((Object)key);
        }
        return this.getProjectIdToProjectRoleIdsFromDelegate(key);
    }

    public void remove(@Nonnull ProjectRoleAndActorStore.RoleTypeMapping key) {
        if (this.oneWayDatabaseVersionFeature.isFeatureEnabled()) {
            this.roleTypeMappingCache.remove((Object)key);
        }
    }

    public void removeAll() {
        if (this.oneWayDatabaseVersionFeature.isFeatureEnabled()) {
            log.info("Clearing caches: {}", (Object)RoleTypeMappingZduSafeCache.class.getSimpleName());
            this.roleTypeMappingCache.removeAll();
        }
    }

    @EventListener
    public void onJiraUpgradedEvent(JiraUpgradedEvent jiraUpgradedEvent) {
        this.removeAll();
    }

    @Nonnull
    private ProjectRoleManager.ProjectIdToProjectRoleIdsMap getProjectIdToProjectRoleIdsFromDelegate(@Nonnull ProjectRoleAndActorStore.RoleTypeMapping key) {
        return this.delegate.getProjectIdToRoleIds(key.getRoleTypeParameter(), key.getRoleType());
    }
}

