/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security.secrets;

import com.atlassian.jira.cluster.ClusterNodeProperties;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.config.util.JiraHome;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.secrets.InternalJiraSecretsStorage;
import com.atlassian.jira.security.secrets.SecretMigrationState;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.secrets.api.SecretDao;
import com.atlassian.secrets.api.SecretService;
import com.atlassian.secrets.api.SecretServiceException;
import com.atlassian.secrets.service.SecretServiceFactory;
import com.atlassian.secrets.service.SecretServiceParams;
import com.google.common.base.Strings;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultInternalJiraSecretsStorage
implements InternalJiraSecretsStorage {
    public static final String SECRETS_CONFIG_FILE_APP_PROPERTY = "jira.secret.config.file";
    public static final String JIRA_SECRET_STORAGE_MIGRATION_STATE = "jira.secret.storage.migration.state";
    private static final Logger log = LoggerFactory.getLogger(DefaultInternalJiraSecretsStorage.class);
    private final ApplicationProperties applicationProperties;
    private final ClusterNodeProperties clusterNodeProperties;
    private final SecretDao jiraSecretDao;
    private final GlobalPermissionManager globalPermissionManager;
    private final JiraAuthenticationContext authenticationContext;
    private final SecretService secretService;

    public DefaultInternalJiraSecretsStorage(ApplicationProperties applicationProperties, ClusterNodeProperties clusterNodeProperties, JiraHome jiraHome, SecretDao jiraSecretDao, GlobalPermissionManager globalPermissionManager, JiraAuthenticationContext authenticationContext) {
        this.applicationProperties = applicationProperties;
        this.clusterNodeProperties = clusterNodeProperties;
        this.globalPermissionManager = globalPermissionManager;
        this.authenticationContext = authenticationContext;
        this.jiraSecretDao = jiraSecretDao;
        Optional<Path> configFilePath = Optional.ofNullable(applicationProperties.getString(SECRETS_CONFIG_FILE_APP_PROPERTY)).map(x$0 -> Paths.get(x$0, new String[0])).map(Path::toAbsolutePath);
        SecretServiceParams.SecretServiceParamsBuilder builder = new SecretServiceParams.SecretServiceParamsBuilder().setSecretDao(jiraSecretDao);
        if (configFilePath.isPresent()) {
            this.validateConfigFilePath(configFilePath.get());
            builder.setSecretsConfigFile(configFilePath.get());
        } else {
            builder.setHomeDirectory(jiraHome.getHome().toPath());
        }
        this.secretService = SecretServiceFactory.getSecretService((SecretServiceParams)builder.build());
    }

    @Override
    public void put(String identifier, String secret) {
        if (secret != null) {
            this.secretService.put(identifier, secret);
        }
    }

    @Override
    public Optional<String> get(String identifier) {
        try {
            return this.secretService.get(identifier);
        }
        catch (SecretServiceException ex) {
            log.debug("Error while unsealing secret " + identifier + " : ", (Throwable)ex);
            return Optional.empty();
        }
    }

    @Override
    public void delete(String identifier) {
        ApplicationUser user = this.authenticationContext.getLoggedInUser();
        if (!this.globalPermissionManager.hasPermission(GlobalPermissionKey.SYSTEM_ADMIN, user)) {
            throw new SecurityException("Only system administrators can remove secrets");
        }
        this.secretService.delete(identifier);
    }

    @Override
    public SecretMigrationState getMigrationState() {
        String propValue = this.applicationProperties.getString(JIRA_SECRET_STORAGE_MIGRATION_STATE);
        if (Strings.isNullOrEmpty((String)propValue)) {
            return SecretMigrationState.NOT_MIGRATED;
        }
        return SecretMigrationState.valueOf((String)propValue);
    }

    private void validateConfigFilePath(Path configFile) {
        if (!configFile.isAbsolute()) {
            throw new IllegalArgumentException("Config file path must be absolute");
        }
        Path sharedHomePath = Paths.get(this.clusterNodeProperties.getSharedHome(), new String[0]).toAbsolutePath();
        if (!configFile.normalize().startsWith(sharedHomePath.normalize())) {
            throw new IllegalArgumentException("Config file must be located in the shared home directory.");
        }
    }
}

