/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security.secrets;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.bc.dataimport.ImportCompletedEvent;
import com.atlassian.secrets.api.SealedSecret;
import com.atlassian.secrets.api.SecretDao;
import com.atlassian.secrets.api.SecretServiceException;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemorySecretsDao
implements SecretDao {
    private final Map<String, SealedSecret> secretsMap = new ConcurrentHashMap<String, SealedSecret>();
    private static final Logger log = LoggerFactory.getLogger(InMemorySecretsDao.class);
    private final EventPublisher eventPublisher;

    public InMemorySecretsDao(EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
        eventPublisher.register((Object)this);
    }

    public void put(Set<SealedSecret> set) throws SecretServiceException {
        set.forEach(secret -> log.debug("Putting secret for identifier: " + secret.getIdentifier()));
        set.forEach(secret -> this.secretsMap.put(secret.getIdentifier(), (SealedSecret)secret));
    }

    public Optional<SealedSecret> get(String identifier) throws SecretServiceException {
        log.trace("Getting secret for identifier: " + identifier);
        return Optional.ofNullable(this.secretsMap.get(identifier));
    }

    public void delete(String s) throws SecretServiceException {
        this.secretsMap.remove(s);
    }

    public Set<String> getIdsForBackend(String s) throws SecretServiceException {
        return this.secretsMap.entrySet().stream().filter(entry -> ((SealedSecret)entry.getValue()).getBackendId().equals(s)).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    @EventListener
    public void onImportCompletedEvent(ImportCompletedEvent event) {
        this.secretsMap.clear();
    }
}

