/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security.type;

import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.index.SecurityIndexingUtils;
import com.atlassian.jira.issue.security.IssueSecurityLevel;
import com.atlassian.jira.permission.PermissionContext;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.type.AbstractProjectsSecurityType;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.ApplicationUsers;
import com.google.common.collect.ImmutableSet;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.util.BytesRef;

public class ProjectLead
extends AbstractProjectsSecurityType {
    public static final String DESC = "lead";
    private JiraAuthenticationContext jiraAuthenticationContext;

    public ProjectLead(JiraAuthenticationContext jiraAuthenticationContext) {
        this.jiraAuthenticationContext = jiraAuthenticationContext;
    }

    @Override
    public String getDisplayName() {
        return this.jiraAuthenticationContext.getI18nHelper().getText("admin.permission.types.project.lead");
    }

    @Override
    public String getType() {
        return DESC;
    }

    @Override
    public boolean hasPermission(Project project, String argument) {
        return false;
    }

    @Override
    public boolean hasPermission(Issue issue, String parameter) {
        return false;
    }

    @Override
    public boolean hasPermission(Project project, String argument, ApplicationUser user, boolean issueCreation) {
        if (project == null) {
            throw new IllegalArgumentException("Project passed must not be null");
        }
        if (user == null) {
            throw new IllegalArgumentException("User passed must not be null");
        }
        String projectLead = project.getLeadUserKey();
        return projectLead != null && projectLead.equals(ApplicationUsers.getKeyFor(user));
    }

    @Override
    public boolean hasPermission(Issue issue, String parameter, ApplicationUser user, boolean issueCreation) {
        return this.hasPermission(issue.getProjectObject(), parameter, user, issueCreation);
    }

    public void doValidation(String key, Map parameters, JiraServiceContext jiraServiceContext) {
    }

    @Override
    public Set<ApplicationUser> getUsers(PermissionContext ctx, String ignored) {
        Project project = ctx.getProjectObject();
        ApplicationUser user = project.getProjectLead();
        HashSet<ApplicationUser> result = new HashSet<ApplicationUser>(1);
        if (user != null) {
            result.add(user);
        }
        return result;
    }

    @Override
    public boolean isTopLevelIssueSecurityPermission() {
        return false;
    }

    @Override
    public Set<BytesRef> getPermissionFieldContents(ApplicationUser searcher, Project project, IssueSecurityLevel securityLevel, String parameter) {
        if (project.getLeadUserKey() == null || !project.getLeadUserKey().equals(ApplicationUsers.getKeyFor(searcher))) {
            return ImmutableSet.of();
        }
        return ImmutableSet.of((Object)SecurityIndexingUtils.generateIssueLevelPermissionContents((Long)securityLevel.getId(), (Long)project.getId()));
    }
}

