/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security.xsrf;

import com.atlassian.jira.JiraFeatureFlagRegistrar;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.web.ExecutingHttpRequest;
import com.opensymphony.util.TextUtils;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.springframework.http.ResponseCookie;

abstract class XsrfTokenStore {
    XsrfTokenStore() {
    }

    abstract void set(String var1);

    abstract String get();

    static XsrfTokenStore session(HttpServletRequest request) {
        return new SessionStore(request);
    }

    static XsrfTokenStore cookie(HttpServletRequest request) {
        return new CookieStore(request);
    }

    static XsrfTokenStore request(HttpServletRequest request) {
        return new RequestStore(request);
    }

    static final class SessionStore
    extends XsrfTokenStore {
        static final String KEY = "atlassian.xsrf.token";
        private final HttpServletRequest request;

        private SessionStore(HttpServletRequest request) {
            this.request = request;
        }

        @Override
        public void set(String token) {
            HttpSession session = this.request.getSession(true);
            session.setAttribute(KEY, (Object)token);
        }

        @Override
        public String get() {
            HttpSession session = this.request.getSession(false);
            if (session == null) {
                return null;
            }
            return (String)session.getAttribute(KEY);
        }
    }

    static final class CookieStore
    extends XsrfTokenStore {
        static final String KEY = "atlassian.xsrf.token";
        private final HttpServletRequest request;
        private final HttpServletResponse response;

        private CookieStore(HttpServletRequest request) {
            this.request = request;
            this.response = ExecutingHttpRequest.getResponse();
        }

        @Override
        public void set(String token) {
            if (ComponentAccessor.getComponentSafely(FeatureManager.class).map(featureManager -> featureManager.isEnabled(JiraFeatureFlagRegistrar.USE_SAME_SITE_FOR_XSRF_TOKEN_COOKIE)).orElse(false).booleanValue()) {
                ResponseCookie.ResponseCookieBuilder cookieBuilder = ResponseCookie.from((String)KEY, (String)token).secure(this.request.isSecure()).path(this.getRequestContext(this.request)).maxAge(-1L);
                if (this.request.isSecure()) {
                    cookieBuilder.sameSite("None");
                }
                this.response.addHeader("Set-Cookie", cookieBuilder.build().toString());
            } else {
                Cookie cookie = new Cookie(KEY, token);
                cookie.setPath(this.getRequestContext(this.request));
                cookie.setMaxAge(-1);
                cookie.setSecure(this.request.isSecure());
                this.response.addCookie(cookie);
            }
        }

        @Override
        public String get() {
            Cookie[] cookies = this.request.getCookies();
            if (cookies != null) {
                for (Cookie cookie : cookies) {
                    if (!KEY.equalsIgnoreCase(cookie.getName())) continue;
                    return TextUtils.htmlEncode((String)cookie.getValue());
                }
            }
            return null;
        }

        private String getRequestContext(HttpServletRequest httpServletRequest) {
            String contextPath = httpServletRequest.getContextPath();
            return StringUtils.isBlank((CharSequence)contextPath) ? "/" : contextPath;
        }
    }

    static final class RequestStore
    extends XsrfTokenStore {
        static final String KEY = "jira.xsrf.set.cookie.pending";
        private final HttpServletRequest request;

        private RequestStore(HttpServletRequest request) {
            this.request = request;
        }

        @Override
        public void set(String token) {
            this.request.setAttribute(KEY, (Object)token);
        }

        @Override
        public String get() {
            return (String)this.request.getAttribute(KEY);
        }
    }
}

