/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security.xsrf;

import com.atlassian.jira.bc.license.JiraServerIdProvider;
import com.atlassian.jira.config.properties.JiraSystemProperties;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.xsrf.XsrfTokenStore;
import com.atlassian.jira.web.filters.accesslog.AtlassianSessionIdUtil;
import com.atlassian.security.random.DefaultSecureTokenGenerator;
import com.atlassian.security.utils.ConstantTimeComparison;
import java.util.Arrays;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class XsrfTokenStrategy {
    static final String LOGGED_IN = "lin";
    static final String LOGGED_OUT = "lout";
    static final String DELIM = JiraSystemProperties.getInstance().getProperty("jira.xsrf.cookie.delim", "_");
    private final JiraAuthenticationContext authContext;
    private final JiraServerIdProvider jiraServerIdProvider;
    private static final Logger logger = LoggerFactory.getLogger(XsrfTokenStrategy.class);

    private XsrfTokenStrategy(JiraAuthenticationContext authContext, JiraServerIdProvider jiraServerIdProvider) {
        this.authContext = authContext;
        this.jiraServerIdProvider = jiraServerIdProvider;
    }

    abstract String getToken(HttpServletRequest var1, boolean var2);

    abstract boolean isValidToken(HttpServletRequest var1, String var2);

    abstract Type getType();

    static String getPendingToken(HttpServletRequest request) {
        return XsrfTokenStore.request(request).get();
    }

    static boolean isGeneratedByAuthenticatedUser(String token) {
        return StringUtils.isNotBlank((CharSequence)token) && token.endsWith(DELIM + LOGGED_IN);
    }

    static boolean tokensEqual(String first, String second) {
        return first != null && second != null && ConstantTimeComparison.isEqual((String)first, (String)second);
    }

    static XsrfTokenStrategy newInstance(Type type, JiraAuthenticationContext authContext, JiraServerIdProvider jiraServerIdProvider) {
        switch (type) {
            case COOKIE: {
                return new CookieBasedStrategy(authContext, jiraServerIdProvider);
            }
            case SESSION: {
                return new SessionBasedStrategy(authContext, jiraServerIdProvider);
            }
        }
        throw new IllegalArgumentException("unknown xsrf token strategy type");
    }

    private String createToken() {
        boolean thereIsAnAuthenticatedUser = this.authContext.getUser() != null;
        String serverId = this.jiraServerIdProvider.getServerId();
        String crytoPart = DefaultSecureTokenGenerator.getInstance().generateToken();
        return serverId + DELIM + crytoPart + DELIM + (thereIsAnAuthenticatedUser ? LOGGED_IN : LOGGED_OUT);
    }

    private String createAndStore(XsrfTokenStore ... stores) {
        String xsrfToken = this.createToken();
        Arrays.stream(stores).forEach(store -> store.set(xsrfToken));
        return xsrfToken;
    }

    private boolean isValidServerSideToken(String token) {
        boolean thereIsAnAuthenticatedUser;
        boolean bl = thereIsAnAuthenticatedUser = this.authContext.getUser() != null;
        if (token != null) {
            if (!this.isOurServerId(token)) {
                return false;
            }
            if (XsrfTokenStrategy.isGeneratedByAuthenticatedUser(token)) {
                return thereIsAnAuthenticatedUser;
            }
            return !thereIsAnAuthenticatedUser;
        }
        return false;
    }

    private boolean isOurServerId(String token) {
        StringTokenizer st = new StringTokenizer(token, DELIM);
        return st.hasMoreElements() && StringUtils.defaultString((String)this.jiraServerIdProvider.getServerId()).equals(st.nextToken());
    }

    private static String getCurrentCookieStoredToken(HttpServletRequest request) {
        String pendingToken = XsrfTokenStrategy.getPendingToken(request);
        return StringUtils.isNotBlank((CharSequence)pendingToken) ? pendingToken : XsrfTokenStore.cookie(request).get();
    }

    private static String sessionIdHash(HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        return session == null ? null : AtlassianSessionIdUtil.generateASESSIONID(session.getId());
    }

    static enum Type {
        COOKIE,
        SESSION;

    }

    private static final class CookieBasedStrategy
    extends XsrfTokenStrategy {
        CookieBasedStrategy(JiraAuthenticationContext authContext, JiraServerIdProvider jiraServerIdProvider) {
            super(authContext, jiraServerIdProvider);
        }

        @Override
        final Type getType() {
            return Type.COOKIE;
        }

        @Override
        public String getToken(HttpServletRequest request, boolean create) {
            String token = XsrfTokenStore.cookie(request).get();
            if (create && !super.isValidServerSideToken(token)) {
                return super.createAndStore(XsrfTokenStore.cookie(request), XsrfTokenStore.request(request));
            }
            return token;
        }

        @Override
        public boolean isValidToken(HttpServletRequest request, String tokenFromClient) {
            String sessionIdHash = XsrfTokenStrategy.sessionIdHash(request);
            String tokenFromCookie = XsrfTokenStrategy.getCurrentCookieStoredToken(request);
            boolean isValid = CookieBasedStrategy.tokensEqual(tokenFromCookie, tokenFromClient);
            if (!isValid) {
                logger.debug("(COOKIE - session: {}) Token mismatch! Cookie '{}' vs Client '{}'.", new Object[]{sessionIdHash, tokenFromCookie, tokenFromClient});
            } else {
                logger.debug("(COOKIE - session: {}) Both tokens are equal. Cookie '{}' vs Client '{}'.", new Object[]{sessionIdHash, tokenFromCookie, tokenFromClient});
            }
            return isValid;
        }
    }

    private static final class SessionBasedStrategy
    extends XsrfTokenStrategy {
        SessionBasedStrategy(JiraAuthenticationContext authContext, JiraServerIdProvider jiraServerIdProvider) {
            super(authContext, jiraServerIdProvider);
        }

        @Override
        final Type getType() {
            return Type.SESSION;
        }

        @Override
        public String getToken(HttpServletRequest request, boolean create) {
            String token = XsrfTokenStore.cookie(request).get();
            String sessionStoredToken = XsrfTokenStore.session(request).get();
            if (!(!create || SessionBasedStrategy.tokensEqual(token, sessionStoredToken) && super.isValidServerSideToken(token))) {
                return super.createAndStore(XsrfTokenStore.cookie(request), XsrfTokenStore.request(request), XsrfTokenStore.session(request));
            }
            return token;
        }

        @Override
        public boolean isValidToken(HttpServletRequest request, String tokenFromClient) {
            String sessionIdHash = XsrfTokenStrategy.sessionIdHash(request);
            if (tokenFromClient == null) {
                logger.debug("(3-way token - session {}) Client token is missing!", (Object)sessionIdHash);
                return false;
            }
            String tokenFromServerSession = XsrfTokenStore.session(request).get();
            if (tokenFromServerSession == null) {
                logger.debug("(3-way token - session: {}) Server session token is missing!", (Object)sessionIdHash);
                return false;
            }
            if (!ConstantTimeComparison.isEqual((String)tokenFromServerSession, (String)tokenFromClient)) {
                logger.debug("(3-way token - session: {}) Token mismatch! Server session '{}' vs Client '{}'", new Object[]{sessionIdHash, tokenFromServerSession, tokenFromClient});
                return false;
            }
            String tokenFromCookie = XsrfTokenStrategy.getCurrentCookieStoredToken(request);
            if (tokenFromCookie == null) {
                logger.debug("(3-way token - session: {}) Cookie token is missing!", (Object)sessionIdHash);
                return false;
            }
            if (!ConstantTimeComparison.isEqual((String)tokenFromServerSession, (String)tokenFromCookie)) {
                logger.debug("(3-way token - session: {}) Token mismatch! Server session '{}' vs Cookie '{}'", new Object[]{sessionIdHash, tokenFromServerSession, tokenFromCookie});
                return false;
            }
            logger.debug("(3-way token - session: {}) All 3 tokens are equal. Server session '{}' | Cookie '{}' | Client '{}'", new Object[]{sessionIdHash, tokenFromServerSession, tokenFromCookie, tokenFromClient});
            return true;
        }
    }
}

