/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.servermetrics;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.core.filters.AbstractHttpFilter;
import com.atlassian.jira.servermetrics.ServletSafeComponentReference;
import com.atlassian.jira.servermetrics.TimingInformationToEvent;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import java.io.IOException;
import java.util.Optional;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@UnrestrictedAccess
public class CorrelationIdPopulatorFilter
extends AbstractHttpFilter {
    private final ServletSafeComponentReference<PageBuilderService> pageBuilderService = ServletSafeComponentReference.build(PageBuilderService.class);

    protected void doFilter(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain filterChain) throws IOException, ServletException {
        Optional<String> correlationID = TimingInformationToEvent.extractCorrelationID(httpServletRequest);
        correlationID.ifPresent(correlationId -> ((Optional)this.pageBuilderService.get()).ifPresent(builderService -> builderService.assembler().data().requireData("jira.request.correlation-id", correlationId)));
        filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
    }
}

