/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.service;

import com.atlassian.configurable.ObjectConfiguration;
import com.atlassian.configurable.ObjectConfigurationException;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.service.JiraService;
import com.atlassian.jira.service.JiraServiceContainer;
import com.atlassian.jira.service.PluginBackedService;
import com.atlassian.jira.service.services.LocalService;
import com.atlassian.jira.util.thread.JiraThreadLocalUtil;
import com.atlassian.jira.util.thread.JiraThreadLocalUtils;
import com.atlassian.scheduler.SchedulerHistoryService;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.status.RunDetails;
import com.opensymphony.module.propertyset.PropertySet;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import org.apache.log4j.Logger;

public class JiraServiceContainerImpl
implements JiraServiceContainer {
    private static final Logger log = Logger.getLogger(JiraServiceContainerImpl.class);
    private final Long id;
    private final JiraService service;
    private final AtomicBoolean running = new AtomicBoolean(false);
    private volatile long delay = -1L;
    private volatile String cronExpression;

    public JiraServiceContainerImpl(JiraService service, Long id) {
        this.service = service;
        this.id = id;
    }

    public void init(PropertySet props, long configurationIdentifier) throws ObjectConfigurationException {
        this.service.init(props, configurationIdentifier);
    }

    @Deprecated
    public void init(PropertySet props) throws ObjectConfigurationException {
        this.service.init(props);
    }

    public void run() {
        if (!this.running.compareAndSet(false, true)) {
            log.debug((Object)"Service was inexplicably in the possible list twice. No harm done.  Just returning without doing anything.");
            return;
        }
        JiraThreadLocalUtils.preCall();
        try {
            this.service.run();
            this.running.set(false);
        }
        catch (Throwable throwable) {
            this.running.set(false);
            JiraThreadLocalUtils.postCall(log, new JiraThreadLocalUtil.WarningCallback(){

                public void onOpenTransaction() {
                    log.error((Object)"Connection not cleared from thread local while running service.");
                    if (JiraServiceContainerImpl.this.service != null) {
                        log.error((Object)("Service name: " + JiraServiceContainerImpl.this.service.getName()));
                    } else {
                        log.error((Object)"The service is null");
                    }
                }
            });
            throw throwable;
        }
        JiraThreadLocalUtils.postCall(log, new /* invalid duplicate definition of identical inner class */);
    }

    public void destroy() {
        this.service.destroy();
    }

    public boolean isInternal() {
        return this.service.isInternal();
    }

    public final long getLastRun() {
        SchedulerHistoryService schedulerHistoryService = (SchedulerHistoryService)ComponentAccessor.getComponent(SchedulerHistoryService.class);
        RunDetails lastRunDetails = schedulerHistoryService.getLastRunForJob(JiraServiceContainerImpl.toJobId(this.id));
        return lastRunDetails != null ? lastRunDetails.getStartTime().getTime() : 0L;
    }

    private static JobId toJobId(long serviceId) {
        return JobId.of((String)(JiraService.class.getName() + ":" + serviceId));
    }

    public final void setLastRun() {
    }

    public void setDelay(long delay) {
        this.delay = delay;
    }

    public long getDelay() {
        return this.delay;
    }

    public String getCronExpression() {
        return this.cronExpression;
    }

    public void setCronExpression(String cronExpression) {
        this.cronExpression = cronExpression;
    }

    public boolean isDueAt(long time) {
        return this.getLastRun() + this.getDelay() <= time;
    }

    public boolean isUnique() {
        return this.service.isUnique();
    }

    public String getDescription() {
        return this.service.getDescription();
    }

    public String getName() {
        return this.service.getName();
    }

    public void setName(String name) {
        this.service.setName(name);
    }

    public ObjectConfiguration getObjectConfiguration() throws ObjectConfigurationException {
        return this.service.getObjectConfiguration();
    }

    public boolean hasProperty(String propertyKey) throws ObjectConfigurationException {
        return this.service.hasProperty(propertyKey);
    }

    public String getProperty(String propertyKey) throws ObjectConfigurationException {
        return this.service.getProperty(propertyKey);
    }

    public String getTextProperty(String propertyKey) throws ObjectConfigurationException {
        return this.service.getTextProperty(propertyKey);
    }

    public Long getLongProperty(String propertyKey) throws ObjectConfigurationException {
        String property = this.getProperty(propertyKey);
        try {
            return new Long(property);
        }
        catch (NumberFormatException e) {
            throw new ObjectConfigurationException("Could not get Long from " + property);
        }
    }

    public String getDefaultProperty(String propertyKey) throws ObjectConfigurationException {
        return this.getObjectConfiguration().getFieldDefault(propertyKey);
    }

    public PropertySet getProperties() throws ObjectConfigurationException {
        return this.service.getProperties();
    }

    public boolean isRunning() {
        return this.running.get();
    }

    public String getKey() {
        throw new UnsupportedOperationException();
    }

    public Long getId() {
        return this.id;
    }

    public String getServiceClass() {
        return this.getServiceClassObject().getName();
    }

    @Nonnull
    public Class<? extends JiraService> getServiceClassObject() {
        return this.service.getClass();
    }

    public boolean isUsable() {
        if (PluginBackedService.class.isAssignableFrom(this.getServiceClassObject())) {
            return ((PluginBackedService)this.service).isAvailable();
        }
        return true;
    }

    public boolean isLocalService() {
        return LocalService.class.isAssignableFrom(this.service.getClass());
    }

    public String toString() {
        return "Container: " + this.service.getClass().getName() + " " + (this.getDescription() != null ? this.getDescription() : "") + " delay [" + this.getDelay() + "ms]";
    }
}

