/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.service.services.export;

import com.atlassian.configurable.ObjectConfiguration;
import com.atlassian.configurable.ObjectConfigurationException;
import com.atlassian.core.AtlassianCoreException;
import com.atlassian.core.util.FileUtils;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.util.FileStores;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.service.AbstractService;
import com.atlassian.jira.task.TaskProgressSink;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.IOUtil;
import com.google.common.base.Joiner;
import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.util.TextUtils;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportService
extends AbstractService {
    public static final String USE_DEFAULT_DIRECTORY = "USE_DEFAULT_DIRECTORY";
    public static final String DIR_NAME = "DIR_NAME";
    public static final String OPT_DATE_FORMAT = "OPT_DATE_FORMAT";
    private static final Logger log = LoggerFactory.getLogger(ExportService.class);
    private static final String DEFAULT_DATE_FORMAT = "yyyy-MMM-dd--HHmm";
    private String dirName;
    private String dateFormat;
    private static final String CORRUPTED_DIRNAME = "corrupted";
    private static final String FAILURE_TXT_EXT = ".failure.txt";
    private final FileStores fileStores;

    public ExportService(FileStores fileStores) {
        this.fileStores = fileStores;
    }

    public void init(PropertySet props) throws ObjectConfigurationException {
        super.init(props);
        boolean useDefaultDirectory = this.isUsingDefaultDirectory();
        this.dirName = useDefaultDirectory ? this.getDefaultExportPath() : (this.hasProperty(DIR_NAME) ? this.getProperty(DIR_NAME) : this.getDefaultExportPath());
        if (this.hasProperty(OPT_DATE_FORMAT)) {
            this.dateFormat = this.getProperty(OPT_DATE_FORMAT);
        }
    }

    private String getDefaultExportPath() {
        return this.fileStores.getExportBackupsPath().asJavaFile().getAbsolutePath();
    }

    private boolean isUsingDefaultDirectory() throws ObjectConfigurationException {
        String key = USE_DEFAULT_DIRECTORY;
        return this.hasProperty(USE_DEFAULT_DIRECTORY) && Boolean.parseBoolean(this.getProperty(USE_DEFAULT_DIRECTORY));
    }

    public void run() {
        log.debug("Jira Export Service Running");
        File backupDir = null;
        File backupFile = null;
        try {
            if (this.dirName == null) {
                log.error("No directory specified for Export Service \"" + this.getName() + "\". Using default directory.");
                this.dirName = this.getDefaultExportPath();
            }
            if (!(backupDir = new File(this.dirName)).exists()) {
                log.info("Backup directory '" + this.dirName + "' for Export Service \"" + this.getName() + "\" does not exist - attempting to create...");
                if (backupDir.mkdirs()) {
                    log.info("Backup directory '" + this.dirName + "' for Export Service \"" + this.getName() + "\" was created.");
                } else {
                    log.warn("Backup directory '" + this.dirName + "' for Export Service \"" + this.getName() + "\" does not exist and JIRA could not create it.");
                    return;
                }
            }
            if (!backupDir.isDirectory()) {
                log.warn("Backup directory " + this.dirName + " for Export Service \"" + this.getName() + "\" is not a directory");
                return;
            }
            if (!backupDir.canWrite()) {
                log.warn("Backup directory " + this.dirName + " for Export Service \"" + this.getName() + "\" is not writable");
                return;
            }
            backupFile = new File(this.dirName, this.createFileName());
            if (backupFile.exists()) {
                log.warn("File " + backupFile.getAbsolutePath() + " for Export Service \"" + this.getName() + "\" exists already.");
                return;
            }
            this.performBackup(backupFile.getAbsolutePath());
            log.debug("Jira Export Service Finished without Exception");
        }
        catch (Exception failureEx) {
            log.error("An exception while running the export service \"" + this.getName() + "\": " + failureEx.getMessage(), (Throwable)failureEx);
            this.moveBackupAside(backupDir, backupFile, failureEx);
        }
    }

    void performBackup(String filename) throws Exception {
        JiraAuthenticationContext authenticationContext;
        com.atlassian.jira.bc.dataimport.ExportService exportService = (com.atlassian.jira.bc.dataimport.ExportService)ComponentAccessor.getComponent(com.atlassian.jira.bc.dataimport.ExportService.class);
        ServiceOutcome<Void> outcome = exportService.export((authenticationContext = (JiraAuthenticationContext)ComponentAccessor.getComponent(JiraAuthenticationContext.class)).getUser(), filename, TaskProgressSink.NULL_SINK);
        if (!outcome.isValid()) {
            throw new AtlassianCoreException(Joiner.on((String)"\n").join((Iterable)outcome.getErrorCollection().getErrorMessages()));
        }
    }

    I18nHelper getI18nHelper() {
        return (I18nHelper)ComponentAccessor.getComponentOfType(I18nHelper.class);
    }

    boolean moveBackupAside(File backupDir, File backupFile, Exception failureEx) {
        if (backupDir == null || backupFile == null || !backupFile.exists()) {
            return false;
        }
        File corruptedDirectory = this.createCorruptedDirectory(backupDir);
        if (corruptedDirectory == null) {
            this.writeFailureReasonFile(backupDir, backupFile, failureEx);
            return false;
        }
        boolean ok = this.moveFailedBackupFile(backupFile, corruptedDirectory);
        this.writeFailureReasonFile(corruptedDirectory, backupFile, failureEx);
        return ok;
    }

    File createCorruptedDirectory(File backupDir) {
        File corruptedDirectory = new File(backupDir, CORRUPTED_DIRNAME);
        try {
            if (corruptedDirectory.exists()) {
                if (corruptedDirectory.isDirectory() && corruptedDirectory.canWrite()) {
                    return corruptedDirectory;
                }
                log.error("Cannot create backup corrupted directory '" + corruptedDirectory.getAbsoluteFile() + "'. it exists but is not a writeable directory.");
                return null;
            }
            if (corruptedDirectory.mkdirs()) {
                return corruptedDirectory;
            }
            log.error("Cannot create backup corrupted directory '" + corruptedDirectory.getAbsoluteFile() + "'. mkdir() failed.");
        }
        catch (Exception e) {
            log.error("Cannot create backup corrupted directory '" + corruptedDirectory.getAbsoluteFile() + "'.", (Throwable)e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeFailureReasonFile(File targetDir, File backupFile, Exception failureEx) {
        String backupFileName = backupFile.getName();
        File reasonFile = new File(targetDir, backupFileName + FAILURE_TXT_EXT);
        PrintWriter pw = null;
        try {
            I18nHelper i18nHelper = this.getI18nHelper();
            pw = new PrintWriter(new FileWriter(reasonFile));
            pw.println(i18nHelper.getText("admin.service.export.backup.failed", backupFile.getAbsolutePath()));
            pw.println(i18nHelper.getText("admin.service.export.backup.movedaside", targetDir.getAbsolutePath()));
            pw.println(i18nHelper.getText("admin.service.export.backup.stacktrace"));
            failureEx.printStackTrace(pw);
            log.warn("A backup failure reason file was written to '" + reasonFile.getAbsolutePath() + "'.");
        }
        catch (IOException e1) {
            try {
                log.error("Unable to create backup failure reason file '" + reasonFile.getAbsolutePath() + "'", (Throwable)e1);
            }
            catch (Throwable throwable) {
                IOUtil.shutdownWriter(pw);
                throw throwable;
            }
            IOUtil.shutdownWriter(pw);
        }
        IOUtil.shutdownWriter(pw);
    }

    boolean moveFailedBackupFile(File backupFile, File targetDir) {
        String backupFileName = backupFile.getName();
        File corruptedBackupFile = new File(targetDir, backupFileName);
        try {
            FileUtils.copyFile((File)backupFile, (File)corruptedBackupFile, (boolean)true);
            if (!backupFile.delete()) {
                log.warn("The corrupted backup file '" + backupFile.getAbsolutePath() + "' was copied to '" + corruptedBackupFile.getAbsolutePath() + "' but could not be deleted.");
                return false;
            }
            log.warn("The corrupted backup file '" + backupFile.getAbsolutePath() + "' was moved to '" + corruptedBackupFile.getAbsolutePath() + "'.");
            return true;
        }
        catch (IOException ioe) {
            log.error("Exception while moving corrupted backup file '" + backupFile.getAbsolutePath() + "' to '" + corruptedBackupFile.getAbsolutePath() + "'.", (Throwable)ioe);
            return false;
        }
    }

    private String createFileName() {
        SimpleDateFormat format = TextUtils.stringSet((String)this.dateFormat) ? new SimpleDateFormat(this.dateFormat) : new SimpleDateFormat(DEFAULT_DATE_FORMAT);
        return format.format(new Date()) + ".zip";
    }

    public void destroy() {
        log.debug("Export service \"" + this.getName() + "\" being destroyed");
    }

    public boolean isUnique() {
        return false;
    }

    public ObjectConfiguration getObjectConfiguration() throws ObjectConfigurationException {
        return this.getObjectConfiguration("EXPORTSERVICE", "services/com/atlassian/jira/service/services/export/exportservice.xml", null);
    }
}

