/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.servlet;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.component.ComponentContainerState;
import com.atlassian.jira.component.pico.ComponentManager;
import com.atlassian.jira.config.properties.JiraProperties;
import com.atlassian.jira.config.properties.JiraSystemProperties;
import com.atlassian.jira.servlet.ApplicationStateResolver;
import com.atlassian.jira.util.JiraUtils;
import com.atlassian.jira.util.index.IndexLifecycleManager;
import com.atlassian.jira.util.johnson.DefaultJohnsonProvider;
import com.atlassian.jira.util.johnson.JiraJohnsonContainer;
import com.atlassian.jira.util.johnson.JohnsonEventType;
import com.atlassian.jira.util.johnson.JohnsonProvider;
import com.atlassian.jira.util.system.status.ApplicationState;
import com.atlassian.johnson.event.Event;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Suppliers;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ApplicationStateResolverImpl
implements ApplicationStateResolver {
    private static final Logger log = LoggerFactory.getLogger(ApplicationStateResolverImpl.class);
    private final Supplier<Boolean> indexConsistent;
    private final JiraProperties properties;

    public ApplicationStateResolverImpl() {
        this(JiraSystemProperties.getInstance());
    }

    @VisibleForTesting
    ApplicationStateResolverImpl(JiraProperties properties) {
        this.properties = properties;
        this.indexConsistent = Suppliers.memoizeWithExpiration(this::checkIndexConsistent, (long)properties.getLong("com.atlassian.jira.status.index.check.expiration.seconds", Long.valueOf(60L)), (TimeUnit)TimeUnit.SECONDS);
    }

    @Override
    public ApplicationState getApplicationState() {
        ComponentContainerState componentManagerState = ComponentManager.getInstance().getState();
        JiraJohnsonContainer jiraJohnsonContainer = this.getJohnsonContainer();
        return this.getApplicationState(componentManagerState, jiraJohnsonContainer);
    }

    private JiraJohnsonContainer getJohnsonContainer() {
        return ComponentAccessor.getComponentSafely(JohnsonProvider.class).orElseGet(DefaultJohnsonProvider::new).getContainer();
    }

    @VisibleForTesting
    ApplicationState getApplicationState(ComponentContainerState state, JiraJohnsonContainer jiraJohnsonContainer) {
        if (jiraJohnsonContainer.hasEventThatPreventsStartup()) {
            if (this.onlyEventIsIndexingOrMissingIndex(jiraJohnsonContainer)) {
                return ApplicationState.MAINTENANCE;
            }
            return ApplicationState.ERROR;
        }
        if (!this.hasStarted(state)) {
            return ApplicationState.STARTING;
        }
        if (ApplicationStateResolverImpl.isFirstRun()) {
            return ApplicationState.FIRST_RUN;
        }
        if (!ApplicationStateResolverImpl.isIndexAvailable()) {
            log.debug("The search index is not available. This might be due to a maintenance task going on. This node will report its status as {}.", (Object)ApplicationState.MAINTENANCE);
            return ApplicationState.MAINTENANCE;
        }
        if (Boolean.FALSE.equals(this.indexConsistent.get())) {
            return ApplicationState.ERROR;
        }
        return ApplicationState.RUNNING;
    }

    private boolean onlyEventIsIndexingOrMissingIndex(JiraJohnsonContainer jiraJohnsonContainer) {
        return jiraJohnsonContainer.getEventsThatPreventStartup().stream().map(Event::getKey).allMatch(key -> key.equals((Object)JohnsonEventType.REINDEX.eventType()) || key.equals((Object)JohnsonEventType.NO_INDEX.eventType()));
    }

    private boolean hasStarted(ComponentContainerState state) {
        return state.isComponentsRegistered() && state.isContainerInitialised() && state.isPluginSystemStarted() && state.isStarted();
    }

    private boolean checkIndexConsistent() {
        String enabled = this.properties.getProperty("com.atlassian.jira.status.index.check");
        if (enabled != null && !Boolean.parseBoolean(enabled)) {
            return true;
        }
        boolean result = ApplicationStateResolverImpl.isIndexConsistent();
        if (!result) {
            log.warn("The search index is inconsistent. This node will report its status as {}. You will find information on how to resolve this problem here: https://jira.atlassian.com/browse/JRASERVER-66970", (Object)ApplicationState.ERROR);
        }
        return result;
    }

    private static boolean isIndexAvailable() {
        return ComponentAccessor.getComponentSafely(IndexLifecycleManager.class).map(IndexLifecycleManager::isIndexAvailable).orElse(false);
    }

    private static boolean isIndexConsistent() {
        return ComponentAccessor.getComponentSafely(IndexLifecycleManager.class).map(IndexLifecycleManager::isIndexConsistent).orElse(false);
    }

    private static boolean isFirstRun() {
        return !JiraUtils.isSetUp();
    }
}

