/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.servlet;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.servlet.ApplicationStateResolver;
import com.atlassian.jira.servlet.ApplicationStateResolverImpl;
import com.atlassian.jira.util.system.status.ApplicationState;
import com.google.common.annotations.VisibleForTesting;
import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;

@OpenAPIDefinition
@Path(value="status")
@Consumes(value={"text/plain"})
@Produces(value={"application/json"})
@Tag(name="servlet")
@UnrestrictedAccess
public class ApplicationStatusServlet
extends HttpServlet {
    @GET
    @Operation(description="Provides application status information.")
    @ApiResponses(value={@ApiResponse(description="Request processed successfully.", responseCode="200"), @ApiResponse(description="Internal server error.", responseCode="500"), @ApiResponse(description="Service unavailable.", responseCode="503")})
    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        ApplicationStateAndHttpStatus state = this.getApplicationState();
        resp.setStatus(state.httpStatus);
        resp.setContentType("application/json");
        resp.getWriter().append("{\"state\":\"").append(state.applicationState.name()).append("\"}");
    }

    private ApplicationStateAndHttpStatus getApplicationState() {
        ApplicationState state = this.getApplicationStateResolver().getApplicationState();
        switch (state) {
            case MAINTENANCE: {
                return new ApplicationStateAndHttpStatus(ApplicationState.MAINTENANCE, 503);
            }
            case ERROR: {
                return new ApplicationStateAndHttpStatus(ApplicationState.ERROR, 500);
            }
        }
        return new ApplicationStateAndHttpStatus(state, 200);
    }

    @VisibleForTesting
    ApplicationStateResolver getApplicationStateResolver() {
        return ComponentAccessor.getComponentSafely(ApplicationStateResolver.class).orElseGet(ApplicationStateResolverImpl::new);
    }

    private static class ApplicationStateAndHttpStatus {
        final ApplicationState applicationState;
        final int httpStatus;

        public ApplicationStateAndHttpStatus(ApplicationState applicationState, int httpStatus) {
            this.applicationState = applicationState;
            this.httpStatus = httpStatus;
        }
    }
}

