/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.servlet;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.servlet.JiraCaptchaService;
import com.google.common.annotations.VisibleForTesting;
import com.octo.captcha.CaptchaException;
import com.octo.captcha.service.CaptchaServiceException;
import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@OpenAPIDefinition
@Path(value="captcha")
@Consumes(value={"text/plain"})
@Produces(value={"text/plain"})
@Tag(name="servlet")
@UnrestrictedAccess
public class JiraCaptchaServlet
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(JiraCaptchaServlet.class);

    @GET
    @Operation(description="Returns a captcha image challenge for a given id. The id used to generate the challenge will be the http session id. Later on, the same id will be used to validate the response to the captcha challenge.")
    @Parameter(name="id", description="Session id.", in=ParameterIn.DEFAULT, required=true)
    @ApiResponses(value={@ApiResponse(description="Request processed successfully.", responseCode="200"), @ApiResponse(description="Session id not found.", responseCode="404"), @ApiResponse(description="Internal server error.", responseCode="500")})
    public void doGet(HttpServletRequest request, HttpServletResponse response) {
        try {
            ByteArrayOutputStream jpegOutputStream = new ByteArrayOutputStream();
            try {
                String captchaId = request.getSession().getId();
                BufferedImage imageChallenge = null;
                while (imageChallenge == null) {
                    try {
                        imageChallenge = JiraCaptchaServlet.getCaptchaService().getImageCaptchaService().getImageChallengeForID(captchaId, request.getLocale());
                    }
                    catch (CaptchaException e) {
                        log.debug("CaptchaException thrown when image was being generated. This was most likely caused by running on OS X which has font size issues. Ignoring the exception. See http://jcaptcha.octo.com/jira/browse/FWK-58.", (Throwable)e);
                    }
                }
                this.writeJpegImage(jpegOutputStream, imageChallenge);
            }
            catch (IllegalArgumentException e) {
                response.sendError(404);
                return;
            }
            catch (CaptchaServiceException e) {
                response.sendError(500);
                return;
            }
            byte[] captchaChallengeAsJpeg = jpegOutputStream.toByteArray();
            JiraCaptchaServlet.setResponseHeaders(response);
            ServletOutputStream responseOutputStream = response.getOutputStream();
            responseOutputStream.write(captchaChallengeAsJpeg);
            responseOutputStream.flush();
            responseOutputStream.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void setResponseHeaders(HttpServletResponse response) {
        response.setHeader("Cache-Control", "no-store");
        response.setHeader("Pragma", "no-cache");
        response.setDateHeader("Expires", 0L);
        response.setContentType("image/jpeg");
    }

    private static JiraCaptchaService getCaptchaService() {
        return (JiraCaptchaService)ComponentAccessor.getComponentSafely(JiraCaptchaService.class).orElseThrow(IllegalStateException::new);
    }

    @VisibleForTesting
    void writeJpegImage(ByteArrayOutputStream os, BufferedImage bufferedImage) throws IOException {
        ImageOutputStream imageOutputStream = ImageIO.createImageOutputStream(os);
        ImageWriter writer = ImageIO.getImageWritersByFormatName("jpeg").next();
        writer.setOutput(imageOutputStream);
        writer.write(bufferedImage);
    }
}

