/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.servlet;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.security.annotated.AnnotatedSecurityChecker;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserRole;
import com.atlassian.sal.core.permission.AccessType;
import com.atlassian.seraph.config.SecurityConfigFactory;
import com.atlassian.seraph.util.RedirectUtils;
import java.io.IOException;
import java.net.URI;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ServletRequestUtil {
    public static final String VIEW_REQUESTED_BY_ACTION = "view.requested.by.action";

    public static String getMethodName(HttpServletRequest request) {
        switch (request.getMethod()) {
            case "GET": {
                return "doGet";
            }
            case "POST": {
                return "doPost";
            }
            case "PUT": {
                return "doPut";
            }
            case "DELETE": {
                return "doDelete";
            }
            case "HEAD": {
                return "doHead";
            }
            case "OPTIONS": {
                return "doOptions";
            }
            case "TRACE": {
                return "doTrace";
            }
        }
        throw new IllegalArgumentException("Unsupported HTTP method: " + request.getMethod());
    }

    public static void clearRedirectAttributes(HttpServletRequest request) {
        request.getSession().removeAttribute(ServletRequestUtil.getOriginalURLKey());
    }

    public static void redirectToLoginScreen(HttpServletRequest request, HttpServletResponse response, AccessType accessType) throws IOException {
        request.getSession().setAttribute(ServletRequestUtil.getOriginalURLKey(), (Object)ServletRequestUtil.getOriginalUri(request));
        response.sendRedirect(RedirectUtils.getLoginURL((String)ServletRequestUtil.getLoginUrl(accessType), (HttpServletRequest)request));
    }

    private static String getOriginalURLKey() {
        return SecurityConfigFactory.getInstance().getOriginalURLKey();
    }

    private static String getOriginalUri(HttpServletRequest request) {
        StringBuffer builder = request.getRequestURL();
        if (request.getQueryString() != null) {
            builder.append("?");
            builder.append(request.getQueryString());
        }
        return URI.create(builder.toString()).toASCIIString();
    }

    private static String getLoginUrl(AccessType accessType) {
        return SecurityConfigFactory.getInstance().getLoginURL(true, false).replaceAll("\\$\\{userRole}", ServletRequestUtil.toUserRole(accessType).toString());
    }

    private static UserRole toUserRole(AccessType accessType) {
        switch (accessType) {
            case SYSTEM_ADMIN_ONLY: {
                return UserRole.SYSADMIN;
            }
            case ADMIN_ONLY: {
                return UserRole.ADMIN;
            }
        }
        return UserRole.USER;
    }

    public static AnnotatedSecurityChecker getSecurityChecker() {
        return new AnnotatedSecurityChecker(ServletRequestUtil.getSalUserManager(), ServletRequestUtil.getFeatureManager());
    }

    private static UserManager getSalUserManager() {
        return ComponentAccessor.getOSGiComponentInstanceOfTypeSafely(UserManager.class).orElse(null);
    }

    private static FeatureManager getFeatureManager() {
        return (FeatureManager)ComponentAccessor.getComponentOfType(FeatureManager.class);
    }

    private ServletRequestUtil() {
    }
}

