/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.sharing;

import com.atlassian.jira.JiraFeatureFlagRegistrar;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.sharing.ShareManager;
import com.atlassian.jira.sharing.SharePermission;
import com.atlassian.jira.sharing.SharePermissionReindexer;
import com.atlassian.jira.sharing.SharePermissionStore;
import com.atlassian.jira.sharing.SharedEntity;
import com.atlassian.jira.sharing.rights.ShareRight;
import com.atlassian.jira.sharing.type.ShareType;
import com.atlassian.jira.sharing.type.ShareTypeFactory;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DefaultShareManager
implements ShareManager {
    private final SharePermissionStore store;
    private final ShareTypeFactory shareTypeFactory;
    private final SharePermissionReindexer reindexer;
    private final FeatureManager featureManager;
    private final GlobalPermissionManager globalPermissionManager;

    public DefaultShareManager(SharePermissionStore store, ShareTypeFactory shareTypeFactory, SharePermissionReindexer reindexer, FeatureManager featureManager, GlobalPermissionManager globalPermissionManager) {
        this.store = Objects.requireNonNull(store);
        this.shareTypeFactory = Objects.requireNonNull(shareTypeFactory);
        this.reindexer = Objects.requireNonNull(reindexer);
        this.featureManager = Objects.requireNonNull(featureManager);
        this.globalPermissionManager = Objects.requireNonNull(globalPermissionManager);
    }

    public SharedEntity.SharePermissions getSharePermissions(SharedEntity entity) {
        return this.store.getSharePermissions(entity);
    }

    public void deletePermissions(SharedEntity entity) {
        this.store.deleteSharePermissions(entity);
    }

    public void deleteSharePermissionsLike(SharePermission permission) {
        this.store.deleteSharePermissionsLike(permission);
        this.reindexer.reindex(permission);
    }

    public SharedEntity.SharePermissions updateSharePermissions(SharedEntity entity) {
        Assertions.notNull((String)"entity", (Object)entity);
        Assertions.notNull((String)"entity.sharePermissions", (Object)entity.getPermissions());
        if (entity.getPermissions().isPrivate()) {
            this.store.deleteSharePermissions(entity);
            return SharedEntity.SharePermissions.PRIVATE;
        }
        return this.store.storeSharePermissions(entity);
    }

    public boolean isSharedWith(ApplicationUser user, SharedEntity sharedEntity) {
        return this.checkPermissionWithRights(user, sharedEntity, SharePermission::isView);
    }

    private boolean checkPermissionWithRights(@Nullable ApplicationUser user, @Nonnull SharedEntity sharedEntity, @Nonnull Predicate<SharePermission> areRightsCorrect) {
        Assertions.notNull((String)"entity", (Object)sharedEntity);
        if (Objects.equals(sharedEntity.getOwner(), user)) {
            return true;
        }
        if (this.featureManager.isEnabled(JiraFeatureFlagRegistrar.ADMINS_CAN_EDIT_PRIVATE_FILTERS_AND_DASHBOARDS) && this.globalPermissionManager.hasPermission(GlobalPermissionKey.ADMINISTER, user)) {
            return true;
        }
        SharedEntity.SharePermissions permissions = this.store.getSharePermissions(sharedEntity);
        if (permissions != null) {
            for (SharePermission sharePermission : permissions) {
                ShareType type;
                if (!areRightsCorrect.test(sharePermission) || (type = this.shareTypeFactory.getShareType(sharePermission.getType())) == null || !type.getPermissionsChecker().hasPermission(user, sharePermission)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isSharedWith(@Nullable ApplicationUser user, @Nonnull SharedEntity sharedEntity, @Nonnull ShareRight shareRight) {
        return this.checkPermissionWithRights(user, sharedEntity, shareRight.hasEditRightsGranted() ? SharePermission::isEdit : SharePermission::isView);
    }
}

