/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.sharing;

import com.atlassian.jira.ofbiz.FieldMap;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.ofbiz.PrimitiveMap;
import com.atlassian.jira.sharing.SharePermission;
import com.atlassian.jira.sharing.SharePermissionImpl;
import com.atlassian.jira.sharing.SharePermissionStore;
import com.atlassian.jira.sharing.SharePermissionUtils;
import com.atlassian.jira.sharing.SharedEntity;
import com.atlassian.jira.sharing.rights.ShareRight;
import com.atlassian.jira.sharing.type.ShareType;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.ofbiz.core.entity.GenericValue;

public class OfBizSharePermissionStore
implements SharePermissionStore {
    private final OfBizDelegator delegator;

    public OfBizSharePermissionStore(OfBizDelegator delegator) {
        this.delegator = delegator;
    }

    @Override
    public SharedEntity.SharePermissions getSharePermissions(SharedEntity entity) {
        this.validate(entity);
        List perms = this.delegator.findByAnd("SharePermissions", new PrimitiveMap.Builder().add("entityId", entity.getId()).add("entityType", entity.getEntityType().getName()).toMap());
        HashSet<SharePermissionImpl> returnPerms = new HashSet<SharePermissionImpl>(perms.size());
        for (GenericValue genericValue : perms) {
            returnPerms.add(this.convertGVToSharePermission(genericValue));
        }
        return new SharedEntity.SharePermissions(returnPerms);
    }

    @Override
    public int deleteSharePermissions(SharedEntity entity) {
        this.validate(entity);
        return this.delegator.removeByAnd("SharePermissions", new PrimitiveMap.Builder().add("entityId", entity.getId()).add("entityType", entity.getEntityType().getName()).toMap());
    }

    @Override
    public int deleteSharePermissionsLike(SharePermission permission) {
        Assertions.notNull((String)"permission", (Object)permission);
        Assertions.notNull((String)"permission.type", (Object)permission.getType());
        if (permission.getParam1() == null && permission.getParam2() == null) {
            throw new IllegalArgumentException("You must provide at least a non null param1 or param2");
        }
        PrimitiveMap.Builder params = new PrimitiveMap.Builder().add("type", permission.getType().get());
        if (permission.getParam1() != null) {
            params.add("param1", permission.getParam1());
        }
        if (permission.getParam2() != null) {
            params.add("param2", permission.getParam2());
        }
        return this.delegator.removeByAnd("SharePermissions", params.toMap());
    }

    @Override
    public SharedEntity.SharePermissions storeSharePermissions(SharedEntity entity) {
        this.validate(entity);
        SharedEntity.SharePermissions permissions = entity.getPermissions();
        this.deleteSharePermissions(entity);
        HashSet<SharePermissionImpl> returnPermissions = new HashSet<SharePermissionImpl>();
        for (SharePermission permission : permissions) {
            GenericValue gv = this.delegator.createValue("SharePermissions", this.createMap(permission, entity));
            returnPermissions.add(this.convertGVToSharePermission(gv));
        }
        return new SharedEntity.SharePermissions(returnPermissions);
    }

    private void validate(SharedEntity entity) {
        Assertions.notNull((String)"entity", (Object)entity);
        Assertions.notNull((String)"entity.id", (Object)entity.getId());
        Assertions.notNull((String)"entity.entityType", (Object)entity.getEntityType());
    }

    Map<String, Object> createMap(SharePermission permission, SharedEntity entity) {
        return new FieldMap().add("entityId", (Object)entity.getId()).add("entityType", (Object)entity.getEntityType().getName()).add("type", (Object)permission.getType().get()).add("param1", (Object)permission.getParam1()).add("param2", (Object)permission.getParam2()).add("rights", (Object)SharePermissionUtils.ShareRightUtils.getIntegerValueFromShareRight((ShareRight)permission.getRights()));
    }

    private SharePermissionImpl convertGVToSharePermission(GenericValue genericValue) {
        return new SharePermissionImpl(genericValue.getLong("id"), new ShareType.Name(genericValue.getString("type")), genericValue.getString("param1"), genericValue.getString("param2"), SharePermissionUtils.ShareRightUtils.fromValue((Integer)genericValue.getInteger("rights")));
    }

    private static final class Table {
        private static final String NAME = "SharePermissions";

        private Table() {
        }
    }

    public static final class Column {
        public static final String ENTITY_ID = "entityId";
        public static final String ENTITY_TYPE = "entityType";
        public static final String PARAM2 = "param2";
        public static final String PARAM1 = "param1";
        public static final String TYPE = "type";
        public static final String ID = "id";
        public static final String RIGHTS = "rights";
    }
}

