/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.sharing.index;

import com.atlassian.jira.cluster.ClusterSafe;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.config.properties.PropertiesUtil;
import com.atlassian.jira.index.AccumulatingResultBuilder;
import com.atlassian.jira.index.DefaultConfiguration;
import com.atlassian.jira.index.DefaultIndex;
import com.atlassian.jira.index.Index;
import com.atlassian.jira.index.Indexes;
import com.atlassian.jira.index.ManagedIndexSearcherFactory;
import com.atlassian.jira.index.Operations;
import com.atlassian.jira.index.UnmanagedIndexSearcher;
import com.atlassian.jira.index.ha.IndexBackupContributionStrategy;
import com.atlassian.jira.index.ha.IndexPerformAndSubpath;
import com.atlassian.jira.index.ha.ReplicatedIndexManager;
import com.atlassian.jira.index.ha.backup.BackupBuilder;
import com.atlassian.jira.sharing.SharedEntity;
import com.atlassian.jira.sharing.SharedEntityAccessor;
import com.atlassian.jira.sharing.index.DefaultDocumentFactory;
import com.atlassian.jira.sharing.index.DefaultQueryFactory;
import com.atlassian.jira.sharing.index.DefaultSharedEntitySearcher;
import com.atlassian.jira.sharing.index.DirectoryFactory;
import com.atlassian.jira.sharing.index.IndexPathDirectoryFactory;
import com.atlassian.jira.sharing.index.QueryBuilder;
import com.atlassian.jira.sharing.index.QueryFactory;
import com.atlassian.jira.sharing.index.SharedEntityDocumentFactory;
import com.atlassian.jira.sharing.index.SharedEntityFieldFactory;
import com.atlassian.jira.sharing.index.SharedEntityIndexer;
import com.atlassian.jira.sharing.index.SharedEntitySearchContextToQueryFactoryMap;
import com.atlassian.jira.sharing.search.SharedEntitySearchResult;
import com.atlassian.jira.sharing.search.SharedEntitySearcher;
import com.atlassian.jira.sharing.type.ShareTypeFactory;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.Function;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnull;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.Term;
import org.apache.lucene.store.Directory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSharedEntityIndexer
implements SharedEntityIndexer {
    private static final Logger log = LoggerFactory.getLogger(DefaultSharedEntityIndexer.class);
    private static final int DEFAULT_WAIT_TIME_SECONDS = 30;
    private final QueryFactory queryFactory;
    private final SharedEntityAccessor.Factory accessorFactory;
    private final IndexFactory indexFactory;
    private final ReplicatedIndexManager replicatedIndexManager;
    private final ReentrantReadWriteLock lock;
    private final IndexBackupContributionStrategy backupPreparationStrategy;
    private final RuntimeException failToAcquireLock = new RuntimeException(){

        @Override
        public Throwable fillInStackTrace() {
            return this;
        }
    };
    private final EntityDocumentFactory documentFactory;
    private DirectoryFactory directoryFactory;
    public static final Index.Manager NULL_MANAGER = new Index.Manager(){

        @Override
        public void close() {
        }

        @Override
        public void deleteIndexDirectory() {
        }

        @Override
        @Nonnull
        public Index getIndex() {
            throw new UnsupportedOperationException();
        }

        @Override
        @Nonnull
        public UnmanagedIndexSearcher openSearcher() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isIndexCreated() {
            throw new UnsupportedOperationException();
        }
    };

    public DefaultSharedEntityIndexer(ShareTypeFactory shareTypeFactory, SharedEntitySearchContextToQueryFactoryMap searchContextToQueryFactoryMap, SharedEntityAccessor.Factory accessorFactory, DirectoryFactory directoryFactory, UserManager userManager, ReplicatedIndexManager replicatedIndexManager, ApplicationProperties applicationProperties, IndexBackupContributionStrategy backupPreparationStrategy) {
        this(new DefaultQueryFactory(shareTypeFactory, searchContextToQueryFactoryMap, userManager), accessorFactory, new DefaultEntityDocumentFactory(shareTypeFactory), directoryFactory, replicatedIndexManager, applicationProperties, backupPreparationStrategy);
        this.directoryFactory = directoryFactory;
    }

    DefaultSharedEntityIndexer(QueryFactory queryFactory, SharedEntityAccessor.Factory accessorFactory, EntityDocumentFactory documentFactory, DirectoryFactory directoryFactory, ReplicatedIndexManager replicatedIndexManager, ApplicationProperties applicationProperties, IndexBackupContributionStrategy backupPreparationStrategy) {
        this.queryFactory = (QueryFactory)Assertions.notNull((String)"queryFactory", (Object)queryFactory);
        this.accessorFactory = (SharedEntityAccessor.Factory)Assertions.notNull((String)"accessorFactory", (Object)accessorFactory);
        this.documentFactory = (EntityDocumentFactory)Assertions.notNull((String)"documentFactory", (Object)documentFactory);
        this.backupPreparationStrategy = (IndexBackupContributionStrategy)Assertions.notNull((String)"backupPreparationStrategy", (Object)backupPreparationStrategy);
        this.indexFactory = new IndexFactory(directoryFactory, applicationProperties);
        this.replicatedIndexManager = replicatedIndexManager;
        this.lock = new ReentrantReadWriteLock();
    }

    @Override
    public Index.Result index(SharedEntity entity) {
        return this.index(entity, true);
    }

    @Override
    public Index.Result deIndex(SharedEntity entity) {
        if (!this.getReadLock()) {
            return new DefaultIndex.Failure(this.failToAcquireLock);
        }
        try {
            this.replicatedIndexManager.deIndexSharedEntity(entity);
            Index.Result result = this.indexFactory.delete(this.documentFactory.get(entity));
            return result;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Index.Result index(SharedEntity entity, boolean shouldReplicate) {
        if (!this.getReadLock()) {
            return new DefaultIndex.Failure(this.failToAcquireLock);
        }
        try {
            if (shouldReplicate) {
                this.replicatedIndexManager.indexSharedEntity(entity);
            }
            Index.Result result = this.indexFactory.update(this.documentFactory.get(entity));
            return result;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Index.Result index(Set<SharedEntity> sharedEntities, boolean shouldReplicate) {
        if (!this.getReadLock()) {
            return new DefaultIndex.Failure(this.failToAcquireLock);
        }
        try {
            AccumulatingResultBuilder builder = new AccumulatingResultBuilder();
            for (SharedEntity entity : sharedEntities) {
                if (shouldReplicate) {
                    this.replicatedIndexManager.indexSharedEntity(entity);
                }
                builder.add(entity.getEntityType().getName(), entity.getId(), this.indexFactory.update(this.documentFactory.get(entity)));
            }
            Index.Result result = builder.toResult();
            return result;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Index.Result deIndex(Set<SharedEntity> sharedEntities, boolean shouldReplicate) {
        if (!this.getReadLock()) {
            return new DefaultIndex.Failure(this.failToAcquireLock);
        }
        try {
            AccumulatingResultBuilder builder = new AccumulatingResultBuilder();
            for (SharedEntity entity : sharedEntities) {
                if (shouldReplicate) {
                    this.replicatedIndexManager.deIndexSharedEntity(entity);
                }
                builder.add(entity.getEntityType().getName(), entity.getId(), this.indexFactory.delete(this.documentFactory.get(entity)));
            }
            Index.Result result = builder.toResult();
            return result;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public <S extends SharedEntity> SharedEntitySearchResult<S> withSearcher(SharedEntity.TypeDescriptor<S> type, java.util.function.Function<SharedEntitySearcher<S>, SharedEntitySearchResult<S>> searcherOperation) {
        if (!this.getReadLock()) {
            return null;
        }
        try {
            UnmanagedIndexSearcher unmanagedIndexSearcher = this.indexFactory.get(type, IndexFactory.Create.YES).openSearcher();
            try {
                SharedEntityAccessor sharedEntityAccessor = this.accessorFactory.getSharedEntityAccessor(type);
                DefaultSharedEntitySearcher sharedEntitySearcher = new DefaultSharedEntitySearcher(ManagedIndexSearcherFactory.createFrom(unmanagedIndexSearcher), sharedEntityAccessor, this.queryFactory);
                SharedEntitySearchResult<S> sharedEntitySearchResult = searcherOperation.apply(sharedEntitySearcher);
                if (unmanagedIndexSearcher != null) {
                    unmanagedIndexSearcher.close();
                }
                return sharedEntitySearchResult;
            }
            catch (Throwable throwable) {
                if (unmanagedIndexSearcher != null) {
                    try {
                        unmanagedIndexSearcher.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private boolean getReadLock() {
        return this.getLock(this.lock.readLock(), "Failed to acquire SharedEntity index read lock");
    }

    private boolean getWriteLock() {
        return this.getLock(this.lock.writeLock(), "Failed to acquire SharedEntity index write lock");
    }

    private boolean getLock(Lock lock, String message) {
        try {
            if (lock.tryLock(30L, TimeUnit.SECONDS)) {
                return true;
            }
            log.warn(message);
        }
        catch (InterruptedException e) {
            log.warn(message, (Throwable)e);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long optimize(SharedEntity.TypeDescriptor<?> type) {
        long start = System.nanoTime();
        if (this.getWriteLock()) {
            try {
                this.indexFactory.get(type, IndexFactory.Create.YES).getIndex().perform(Operations.newOptimize()).await();
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
        return TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start);
    }

    @Override
    public String clear(SharedEntity.TypeDescriptor<?> type) {
        if (this.getWriteLock()) {
            try {
                this.indexFactory.get(type, IndexFactory.Create.NO).deleteIndexDirectory();
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
        return "todo-something here?";
    }

    @Override
    public void recreate(SharedEntity.TypeDescriptor<?> type) {
        if (this.getWriteLock()) {
            try {
                this.indexFactory.get(type, IndexFactory.Create.YES).deleteIndexDirectory();
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
    }

    @Override
    public void contributeToSnapshot(SharedEntity.TypeDescriptor<? extends SharedEntity> entityType, BackupBuilder backupBuilder) {
        Index.Manager indexManager = this.indexFactory.get(entityType, IndexFactory.Create.YES);
        if (!NULL_MANAGER.equals(indexManager)) {
            this.backupPreparationStrategy.addToBackup(backupBuilder, Collections.singleton(new IndexPerformAndSubpath(indexManager.getIndex()::perform, ((IndexPathDirectoryFactory)this.directoryFactory).getIndexSubPath(entityType))));
        } else {
            log.debug("{} is not open, skipping", (Object)entityType.getName());
        }
    }

    @Override
    public void shutdown(SharedEntity.TypeDescriptor<?> type) {
        try {
            this.indexFactory.get(type, IndexFactory.Create.NO).close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public Collection<String> getAllIndexPaths() {
        return Collections.emptyList();
    }

    static class DefaultEntityDocumentFactory
    implements EntityDocumentFactory {
        private final SharedEntityDocumentFactory documentFactory;

        DefaultEntityDocumentFactory(ShareTypeFactory shareTypeFactory) {
            this.documentFactory = this.createDocumentFactory(shareTypeFactory);
        }

        SharedEntityDocumentFactory createDocumentFactory(ShareTypeFactory shareTypeFactory) {
            return DefaultDocumentFactory.create(shareTypeFactory);
        }

        @Override
        public EntityDocument get(final SharedEntity entity) {
            return new EntityDocument(){
                private final Term identifyingTerm;
                {
                    this.identifyingTerm = new Term(SharedEntityFieldFactory.Default.ID.getFieldName(), entity.getId().toString());
                }

                @Override
                public Term getIdentifyingTerm() {
                    return this.identifyingTerm;
                }

                @Override
                public Document getDocument() {
                    return documentFactory.create(entity);
                }

                @Override
                public SharedEntity.TypeDescriptor<?> getType() {
                    return entity.getEntityType();
                }
            };
        }
    }

    public static interface EntityDocumentFactory {
        public EntityDocument get(SharedEntity var1);
    }

    private static final class IndexFactory {
        private final Function<SharedEntity.TypeDescriptor<?>, Directory> directoryFactory;
        @ClusterSafe
        private final ConcurrentMap<SharedEntity.TypeDescriptor<?>, Index.Manager> managers = new ConcurrentHashMap();
        private final ApplicationProperties applicationProperties;

        IndexFactory(Function<SharedEntity.TypeDescriptor<?>, Directory> directoryFactory, ApplicationProperties applicationProperties) {
            this.directoryFactory = (Function)Assertions.notNull((String)"directoryFactory", directoryFactory);
            this.applicationProperties = applicationProperties;
        }

        Index.Manager get(SharedEntity.TypeDescriptor<?> type, Create option) {
            if (option.create()) {
                return this.managers.computeIfAbsent(type, typeDescriptor -> {
                    int maxQueueSize = PropertiesUtil.getIntProperty((ApplicationProperties)this.applicationProperties, (String)"jira.index.sharedentity.maxqueuesize", (int)1000);
                    return Indexes.createQueuedIndexManager(type.getName(), new DefaultConfiguration((Directory)this.directoryFactory.apply((Object)type), QueryBuilder.Analyzers.LOWERCASE), maxQueueSize);
                });
            }
            return this.managers.getOrDefault(type, NULL_MANAGER);
        }

        Index.Result delete(EntityDocument document) {
            Index index = this.get(document.getType(), Create.YES).getIndex();
            return index.perform(Operations.newDelete(document.getIdentifyingTerm(), Index.UpdateMode.INTERACTIVE));
        }

        Index.Result update(EntityDocument document) {
            Index index = this.get(document.getType(), Create.YES).getIndex();
            return index.perform(Operations.newUpdate(document.getIdentifyingTerm(), document.getDocument(), Index.UpdateMode.INTERACTIVE));
        }

        static enum Create {
            YES(true),
            NO(false);

            private final boolean create;

            private Create(boolean create) {
                this.create = create;
            }

            boolean create() {
                return this.create;
            }
        }
    }

    public static interface EntityDocument {
        public SharedEntity.TypeDescriptor<?> getType();

        public Term getIdentifyingTerm();

        public Document getDocument();
    }
}

