/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.sharing.index;

import com.atlassian.jira.index.ManagedIndexSearcher;
import com.atlassian.jira.issue.statistics.util.FieldHitCollector;
import com.atlassian.jira.sharing.IdsRetrievalDescriptor;
import com.atlassian.jira.sharing.SharedEntity;
import com.atlassian.jira.sharing.SharedEntityAccessor;
import com.atlassian.jira.sharing.SharedEntityColumn;
import com.atlassian.jira.sharing.SharedEntityColumnDefinition;
import com.atlassian.jira.sharing.index.QueryFactory;
import com.atlassian.jira.sharing.search.SharedEntitySearchParameters;
import com.atlassian.jira.sharing.search.SharedEntitySearchResult;
import com.atlassian.jira.sharing.search.SharedEntitySearcher;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.Function;
import com.atlassian.jira.util.collect.CollectionUtil;
import com.atlassian.jira.util.dbc.Assertions;
import java.io.IOException;
import java.util.List;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.search.FieldComparatorSource;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TopDocs;

public class DefaultSharedEntitySearcher<S extends SharedEntity>
implements SharedEntitySearcher<S> {
    private static final SortFieldFactory SORT_FACTORY = new SortFieldFactory();
    private final ManagedIndexSearcher managedIndexSearcher;
    private final SharedEntityAccessor<S> accessor;
    private final QueryFactory queryFactory;

    DefaultSharedEntitySearcher(ManagedIndexSearcher managedIndexSearcher, SharedEntityAccessor<S> accessor, QueryFactory queryFactory) {
        this.managedIndexSearcher = (ManagedIndexSearcher)Assertions.notNull((String)"managedIndexSearcher", (Object)managedIndexSearcher);
        this.accessor = (SharedEntityAccessor)Assertions.notNull((String)"accessor", accessor);
        this.queryFactory = (QueryFactory)Assertions.notNull((String)"queryFactory", (Object)queryFactory);
    }

    @Override
    public SharedEntitySearchResult<S> search(SharedEntitySearchParameters searchParameters, ApplicationUser user, final int pageOffset, final int pageWidth) {
        this.checkParametersForSanity(searchParameters, pageOffset, pageWidth);
        final Query query = this.queryFactory.create(searchParameters, user);
        final Sort sort = searchParameters.getSortColumn() == null ? null : new Sort((SortField[])new SharedEntitySortField[]{SORT_FACTORY.getSortField(searchParameters.getSortColumn(), !searchParameters.isAscendingSort()), SharedEntitySortField.NAME, SharedEntitySortField.ID});
        return new Engine(true){

            @Override
            TopDocs getHits() throws IOException {
                int maxHits = pageOffset * pageWidth + pageWidth;
                if (sort == null) {
                    return DefaultSharedEntitySearcher.this.managedIndexSearcher.search(query, maxHits);
                }
                return DefaultSharedEntitySearcher.this.managedIndexSearcher.search(query, maxHits, sort);
            }

            @Override
            Page page(TopDocs source) {
                return new Page(source, pageOffset, pageWidth, DefaultSharedEntitySearcher.this.managedIndexSearcher);
            }
        }.search(user);
    }

    @Override
    public SharedEntitySearchResult<S> search(SharedEntitySearchParameters searchParameters) {
        final Query query = this.queryFactory.create((SharedEntitySearchParameters)Assertions.notNull((String)"searchParameters", (Object)searchParameters));
        return new Engine(false){

            @Override
            TopDocs getHits() throws IOException {
                return DefaultSharedEntitySearcher.this.managedIndexSearcher.search(query, Integer.MAX_VALUE);
            }

            @Override
            Page page(TopDocs source) {
                return new All(source, DefaultSharedEntitySearcher.this.managedIndexSearcher);
            }
        }.search();
    }

    private void checkParametersForSanity(SharedEntitySearchParameters searchParameters, int pageOffset, int pageWidth) {
        Assertions.notNull((String)"searchParameters", (Object)searchParameters);
        Assertions.not((String)"pageOffset < 0", (pageOffset < 0 ? 1 : 0) != 0);
        Assertions.not((String)"pageWidth <= 0", (pageWidth <= 0 ? 1 : 0) != 0);
        Assertions.not((String)"pageWidth of MAX_VALUE used with non zero pageOffset", (pageWidth == Integer.MAX_VALUE && pageOffset != 0 ? 1 : 0) != 0);
    }

    static final class SharedEntitySortField
    extends SortField {
        static final SharedEntitySortField NAME = new SharedEntitySortField(SharedEntityColumnDefinition.NAME, false);
        static final SharedEntitySortField ID = new SharedEntitySortField(SharedEntityColumnDefinition.ID, false);

        SharedEntitySortField(SharedEntityColumnDefinition column, boolean reverse) {
            super(column.getSortColumn(), column.getSortType(), reverse);
        }

        SharedEntitySortField(SharedEntityColumnDefinition column, FieldComparatorSource FieldComparatorSource2, boolean reverse) {
            super(column.getSortColumn(), FieldComparatorSource2, reverse);
        }
    }

    private static class SortFieldFactory {
        private SortFieldFactory() {
        }

        SharedEntitySortField getSortField(SharedEntityColumn column, boolean reverse) {
            SharedEntityColumnDefinition columnDefinition = SharedEntityColumnDefinition.definitionFor(column);
            if (columnDefinition.isCustomSort()) {
                return new SharedEntitySortField(columnDefinition, columnDefinition.createSortComparator(), reverse);
            }
            return new SharedEntitySortField(columnDefinition, reverse);
        }
    }

    class All
    extends Page {
        public All(TopDocs hits, ManagedIndexSearcher searcher) {
            super(hits, 0, (int)hits.totalHits, searcher);
        }
    }

    class Page {
        private final List<String> result;
        private final boolean hasNext;

        private Page(TopDocs hits, int pageOffset, int pageWidth, ManagedIndexSearcher searcher) {
            int startOffset = (int)Math.min(hits.totalHits, (long)(pageOffset * pageWidth));
            int endOffset = (int)Math.min(hits.totalHits, (long)(startOffset + pageWidth));
            FieldHitCollector collector = new FieldHitCollector("id");
            for (int i = startOffset; i < endOffset; ++i) {
                try {
                    Document doc = searcher.doc(hits.scoreDocs[i].doc);
                    collector.collect(doc);
                    continue;
                }
                catch (CorruptIndexException e) {
                    throw new RuntimeException(e);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            this.result = collector.getValues();
            this.hasNext = hits.totalHits > (long)endOffset;
        }

        public List<String> list() {
            return this.result;
        }

        public boolean hasNext() {
            return this.hasNext;
        }
    }

    abstract class Engine {
        private final boolean preserveSort;

        private Engine(boolean preserveSort) {
            this.preserveSort = preserveSort;
        }

        abstract TopDocs getHits() throws IOException;

        abstract Page page(TopDocs var1);

        SharedEntitySearchResult<S> search(ApplicationUser user) {
            TopDocs hits;
            try {
                hits = this.getHits();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            Page page = this.page(hits);
            IdsRetrievalDescriptor ids = new IdsRetrievalDescriptor(CollectionUtil.transform(page.list(), Transformers.STRING_TO_LONG), this.preserveSort);
            return new SharedEntitySearchResult(DefaultSharedEntitySearcher.this.accessor.get(user, (SharedEntityAccessor.RetrievalDescriptor)ids), page.hasNext(), (int)hits.totalHits);
        }

        SharedEntitySearchResult<S> search() {
            TopDocs hits;
            try {
                hits = this.getHits();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            Page page = this.page(hits);
            IdsRetrievalDescriptor ids = new IdsRetrievalDescriptor(CollectionUtil.transform(page.list(), Transformers.STRING_TO_LONG), this.preserveSort);
            return new SharedEntitySearchResult(DefaultSharedEntitySearcher.this.accessor.get((SharedEntityAccessor.RetrievalDescriptor)ids), page.hasNext(), (int)hits.totalHits);
        }
    }

    private static class Transformers {
        static final Function<String, Long> STRING_TO_LONG = input -> Long.valueOf(String.valueOf(input));

        private Transformers() {
        }
    }
}

