/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.sharing.type;

import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.InternalProjectPermissionHelper;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.jira.security.roles.ProjectRoleActor;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.jira.security.roles.RoleActorFactory;
import com.atlassian.jira.sharing.SharePermission;
import com.atlassian.jira.sharing.SharedEntity;
import com.atlassian.jira.sharing.search.ProjectShareTypeSearchParameter;
import com.atlassian.jira.sharing.search.ShareTypeSearchParameter;
import com.atlassian.jira.sharing.type.ProjectSharePermission;
import com.atlassian.jira.sharing.type.ShareQueryFactory;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;

public class ProjectShareQueryFactory
implements ShareQueryFactory<ProjectShareTypeSearchParameter> {
    private final Visibility visibility;

    public ProjectShareQueryFactory(ProjectManager projectManager, ProjectRoleManager projectRoleManager, RoleActorFactory roleActorFactory, InternalProjectPermissionHelper projectPermissionHelper) {
        this(new VisibilityImpl(projectManager, projectRoleManager, roleActorFactory, projectPermissionHelper));
    }

    public ProjectShareQueryFactory(Visibility visibility) {
        this.visibility = visibility;
    }

    public Query getQuery(ShareTypeSearchParameter searchParameter, ApplicationUser user) {
        ProjectShareTypeSearchParameter projectParameter = (ProjectShareTypeSearchParameter)searchParameter;
        this.visibility.check(user, projectParameter);
        TermQuery projectQuery = new TermQuery(new Term("shareTypeProject", ProjectSharePermission.indexValue((Long)projectParameter.getProjectId(), (Long)projectParameter.getRoleId())));
        if (projectParameter.hasRole()) {
            return projectQuery;
        }
        BooleanQuery.Builder result = new BooleanQuery.Builder();
        result.add((Query)projectQuery, BooleanClause.Occur.SHOULD);
        for (ProjectRole role : this.visibility.getRoles(user, projectParameter.getProjectId())) {
            result.add((Query)new TermQuery(new Term("shareTypeProject", ProjectSharePermission.indexValue((Long)projectParameter.getProjectId(), (Long)role.getId()))), BooleanClause.Occur.SHOULD);
        }
        return result.build();
    }

    public Query getQuery(ShareTypeSearchParameter searchParameter) {
        ProjectShareTypeSearchParameter projectParameter = (ProjectShareTypeSearchParameter)searchParameter;
        TermQuery projectQuery = new TermQuery(new Term("shareTypeProject", ProjectSharePermission.indexValue((Long)projectParameter.getProjectId(), (Long)projectParameter.getRoleId())));
        if (projectParameter.hasRole()) {
            return projectQuery;
        }
        BooleanQuery.Builder result = new BooleanQuery.Builder();
        result.add((Query)projectQuery, BooleanClause.Occur.SHOULD);
        result.add((Query)new PrefixQuery(new Term("shareTypeProject", ProjectSharePermission.searchAllRolesValue((Long)projectParameter.getProjectId()))), BooleanClause.Occur.SHOULD);
        return result.build();
    }

    public Term[] getTerms(ApplicationUser user) {
        List<ProjectAndRole> projectsAndRoles = this.visibility.getProjects(user);
        Term[] result = new Term[projectsAndRoles.size()];
        for (int i = 0; i < result.length; ++i) {
            ProjectAndRole projectAndRole = projectsAndRoles.get(i);
            result[i] = new Term("shareTypeProject", ProjectSharePermission.indexValue((Long)projectAndRole.getProjectId(), (Long)projectAndRole.getRoleId()));
        }
        return result;
    }

    public Field getField(SharedEntity entity, SharePermission permission) {
        return new StringField("shareTypeProject", new ProjectSharePermission(permission).getIndexValue(), Field.Store.YES);
    }

    static class VisibilityImpl
    implements Visibility {
        private final ProjectManager projectManager;
        private final ProjectRoleManager projectRoleManager;
        private final RoleActorFactory roleActorFactory;
        private final InternalProjectPermissionHelper projectPermissionHelper;

        VisibilityImpl(ProjectManager projectManager, ProjectRoleManager projectRoleManager, RoleActorFactory roleActorFactory, InternalProjectPermissionHelper projectPermissionHelper) {
            Assertions.notNull((String)"projectManager", (Object)projectManager);
            Assertions.notNull((String)"projectRoleManager", (Object)projectRoleManager);
            Assertions.notNull((String)"projectPermissionHelper", (Object)projectPermissionHelper);
            this.projectManager = projectManager;
            this.projectRoleManager = projectRoleManager;
            this.roleActorFactory = roleActorFactory;
            this.projectPermissionHelper = projectPermissionHelper;
        }

        @Override
        public void check(ApplicationUser user, ProjectShareTypeSearchParameter projectParameter) {
            ProjectRole role;
            Project project = this.projectManager.getProjectObj(projectParameter.getProjectId());
            if (!this.projectPermissionHelper.canUserBrowseProject(project, user)) {
                throw new IllegalStateException("Cannot search for a Project you cannot see: " + project);
            }
            Long roleId = projectParameter.getRoleId();
            if (roleId != null && !this.projectRoleManager.isUserInProjectRole(user, role = this.projectRoleManager.getProjectRole(roleId), project)) {
                throw new IllegalStateException("Cannot search for a ProjectRole you not a member of: " + role + " project:" + project);
            }
        }

        @Override
        public List<ProjectAndRole> getProjects(ApplicationUser user) {
            Set allUserRoleActors = this.roleActorFactory.getAllRoleActorsForUser(user);
            Collection<Project> allProjects = this.projectPermissionHelper.getBrowsableProjects(user);
            return (List)Stream.concat(allUserRoleActors.stream().map(ProjectAndRole::fromProjectRoleActor), allProjects.stream().map(ProjectAndRole::fromProject)).collect(CollectorsUtil.toImmutableList());
        }

        @Override
        public List<ProjectRole> getRoles(ApplicationUser user, Long projectId) {
            Project project = this.projectManager.getProjectObj(projectId);
            return Collections.unmodifiableList(new ArrayList(this.projectRoleManager.getProjectRoles(user, project)));
        }
    }

    static interface Visibility {
        public void check(ApplicationUser var1, ProjectShareTypeSearchParameter var2) throws IllegalStateException;

        public List<ProjectAndRole> getProjects(ApplicationUser var1);

        public List<ProjectRole> getRoles(ApplicationUser var1, Long var2);
    }

    private static final class Name {
        static final String FIELD = "shareTypeProject";

        private Name() {
        }
    }

    static class ProjectAndRole {
        private final Long projectId;
        private final Long projectRoleId;

        public static ProjectAndRole fromProjectRoleActor(ProjectRoleActor projectRoleActor) {
            return new ProjectAndRole(projectRoleActor.getProjectId(), projectRoleActor.getProjectRoleId());
        }

        public static ProjectAndRole fromProject(Project project) {
            return new ProjectAndRole(project.getId(), null);
        }

        public ProjectAndRole(Long projectId, Long projectRoleId) {
            Assertions.notNull((String)"projectId", (Object)projectId);
            this.projectId = projectId;
            this.projectRoleId = projectRoleId;
        }

        Long getProjectId() {
            return this.projectId;
        }

        Long getRoleId() {
            return this.projectRoleId;
        }
    }
}

