/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.startup;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.health.HealthCheck;
import com.atlassian.jira.health.HealthCheckMessageFormatter;
import com.atlassian.jira.health.HealthCheckResult;
import com.atlassian.jira.health.HealthCheckTemplate;
import com.atlassian.jira.health.LifecyclePhase;
import com.atlassian.jira.util.UrlBuilder;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.util.johnson.JohnsonEventLevel;
import com.atlassian.jira.util.johnson.JohnsonEventType;
import com.atlassian.johnson.event.Event;
import com.atlassian.johnson.event.EventLevel;
import com.atlassian.johnson.event.EventType;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.PluginState;
import com.atlassian.plugin.metadata.PluginMetadataManager;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemPluginsEnabledHealthCheck
extends HealthCheckTemplate {
    private static final Logger LOGGER = LoggerFactory.getLogger(SystemPluginsEnabledHealthCheck.class);
    private static final String CAUSE = "system-plugins-failed-to-start";
    public static final URL KB_URL = UrlBuilder.createURL((String)"https://confluence.atlassian.com/x/AA2DFw");
    private final AtomicReference<ImmutableList<PluginInfo>> disabledSystemPluginKeys = new AtomicReference<Object>(null);

    public SystemPluginsEnabledHealthCheck(HealthCheck ... prerequisites) {
        super(Arrays.asList(prerequisites));
    }

    @Override
    protected Set<LifecyclePhase> getApplicablePhases() {
        return ImmutableSet.of((Object)((Object)LifecyclePhase.PLUGINS_STARTUP_FINISHED));
    }

    @Override
    protected List<HealthCheckResult> doPerform() {
        ImmutableList<PluginInfo> pluginKeys = this.disabledSystemPluginKeys();
        if (!pluginKeys.isEmpty()) {
            HealthCheckMessageFormatter healthCheckMessageFormatter = this.getFaultDescriptionFormatter();
            LOGGER.error(healthCheckMessageFormatter.toText());
            Event johnsonEvent = new Event(this.getSystemPluginsEventType(), "We haven't been able to start all the required system plugins", healthCheckMessageFormatter.toHtml(), this.getFatalEventLevel());
            return HealthCheckResult.fail(this, johnsonEvent, KB_URL, CAUSE, healthCheckMessageFormatter.toText());
        }
        return Collections.emptyList();
    }

    public boolean isOk() {
        return this.disabledSystemPluginKeys().isEmpty();
    }

    private HealthCheckMessageFormatter getFaultDescriptionFormatter() {
        HealthCheckMessageFormatter messageFormatter = new HealthCheckMessageFormatter();
        messageFormatter.append(HealthCheckMessageFormatter.string("We couldn't start the following plugins:"));
        messageFormatter.addLineBreak();
        messageFormatter.appendList(this.disabledSystemPluginKeys.get().stream().map(x -> HealthCheckMessageFormatter.string(x.toString())).collect(Collectors.toList()));
        return messageFormatter;
    }

    private ImmutableList<PluginInfo> disabledSystemPluginKeys() {
        ImmutableList<PluginInfo> disabledKeys = this.disabledSystemPluginKeys.get();
        if (disabledKeys == null) {
            ImmutableList<PluginInfo> newList = this.calculateDisabledSystemPlugins();
            boolean wasSet = this.disabledSystemPluginKeys.compareAndSet(null, newList);
            return wasSet ? newList : this.disabledSystemPluginKeys.get();
        }
        return disabledKeys;
    }

    private ImmutableList<PluginInfo> calculateDisabledSystemPlugins() {
        PluginAccessor pluginAccessor = this.getPluginAccessor();
        if (pluginAccessor == null) {
            throw new IllegalStateException("PluginAccessor is null");
        }
        PluginMetadataManager pluginMetadataManager = this.getPluginMetadataManager();
        if (pluginMetadataManager == null) {
            throw new IllegalStateException("PluginMetadataManager is null");
        }
        Collection allPlugins = pluginAccessor.getPlugins();
        LOGGER.trace("All plugins: {}", (Object)allPlugins);
        ImmutableList systemPlugins = ImmutableList.copyOf((Iterable)Iterables.filter((Iterable)allPlugins, (Predicate)new SystemPluginPredicate(pluginMetadataManager)));
        LOGGER.trace("System plugins: {}", (Object)systemPlugins);
        ImmutableList disabledSystemPlugins = ImmutableList.copyOf((Iterable)Iterables.filter((Iterable)systemPlugins, (Predicate)new PluginNotEnabledPredicate()));
        LOGGER.trace("Disabled system plugins: {}", (Object)disabledSystemPlugins);
        return ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)disabledSystemPlugins, (Function)new ExtractPluginInfoFunction()));
    }

    @VisibleForTesting
    protected PluginMetadataManager getPluginMetadataManager() {
        return (PluginMetadataManager)ComponentAccessor.getComponent(PluginMetadataManager.class);
    }

    @VisibleForTesting
    protected PluginAccessor getPluginAccessor() {
        return ComponentAccessor.getPluginAccessor();
    }

    @VisibleForTesting
    protected EventLevel getFatalEventLevel() {
        return JohnsonEventLevel.FATAL.eventLevel();
    }

    EventType getSystemPluginsEventType() {
        return JohnsonEventType.SYSTEM_PLUGINS.eventType();
    }

    private static class SystemPluginPredicate
    implements Predicate<Plugin> {
        private final PluginMetadataManager pluginMetadataManager;

        SystemPluginPredicate(PluginMetadataManager pluginMetadataManager) {
            this.pluginMetadataManager = pluginMetadataManager;
        }

        public boolean apply(Plugin plugin) {
            return !this.pluginMetadataManager.isOptional(plugin);
        }
    }

    private class PluginNotEnabledPredicate
    implements Predicate<Plugin> {
        private PluginNotEnabledPredicate() {
        }

        public boolean apply(Plugin input) {
            return !PluginState.ENABLED.equals((Object)input.getPluginState());
        }
    }

    private static class ExtractPluginInfoFunction
    implements Function<Plugin, PluginInfo> {
        private ExtractPluginInfoFunction() {
        }

        public PluginInfo apply(Plugin plugin) {
            return new PluginInfo(plugin.getKey(), plugin.getName());
        }
    }

    static class PluginInfo {
        final String key;
        final String name;

        PluginInfo(String key, String name) {
            this.key = (String)Assertions.notNull((Object)key);
            this.name = (String)Assertions.notNull((Object)name);
        }

        public String toString() {
            return this.name + " (" + this.key + ")";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PluginInfo that = (PluginInfo)o;
            if (!this.key.equals(that.key)) {
                return false;
            }
            return this.name.equals(that.name);
        }

        public int hashCode() {
            int result = this.key.hashCode();
            result = 31 * result + this.name.hashCode();
            return result;
        }
    }
}

