/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.template;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.event.api.EventListener;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.template.CachingJiraHomeTemplateContentLoader;
import com.atlassian.jira.template.JiraHomeTemplateContentLoader;
import com.atlassian.jira.util.InjectableComponent;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EventComponent
@InjectableComponent
public class CachingJiraHomeTemplateContentLoaderImpl
implements CachingJiraHomeTemplateContentLoader {
    private static final Logger LOG = LoggerFactory.getLogger(CachingJiraHomeTemplateContentLoaderImpl.class);
    private final Cache<String, String> templatesCache;
    private final Cache<String, String> cssCache;
    private final JiraHomeTemplateContentLoader jiraHomeTemplateContentLoader;

    public CachingJiraHomeTemplateContentLoaderImpl(JiraHomeTemplateContentLoader jiraHomeTemplateContentLoader, CacheManager cacheManager) {
        this.jiraHomeTemplateContentLoader = jiraHomeTemplateContentLoader;
        this.templatesCache = cacheManager.getCache(this.getClass().getName() + ".templatesCache", null, new CacheSettingsBuilder().remote().replicateViaInvalidation().unflushable().build());
        this.cssCache = cacheManager.getCache(this.getClass().getName() + ".cssCache", null, new CacheSettingsBuilder().remote().replicateViaInvalidation().unflushable().build());
    }

    public Optional<String> getTemplateContent(String templateFileName) {
        try {
            return Optional.of((String)this.templatesCache.get((Object)templateFileName, () -> (String)this.jiraHomeTemplateContentLoader.getTemplateContent(templateFileName).orElseThrow(() -> new RuntimeException(String.format("Couldn't load template! templateFile: %s", templateFileName)))));
        }
        catch (Exception e) {
            LOG.warn("Exception:", (Throwable)e);
            return Optional.empty();
        }
    }

    public Optional<String> getCssContent(String cssFileName) {
        try {
            return Optional.of((String)this.cssCache.get((Object)cssFileName, () -> (String)this.jiraHomeTemplateContentLoader.getCssContent(cssFileName).orElseThrow(() -> new RuntimeException(String.format("Couldn't load css! cssFile:%s", cssFileName)))));
        }
        catch (Exception e) {
            LOG.warn("Exception:", (Throwable)e);
            return Optional.empty();
        }
    }

    public void clearTemplatesCache() {
        this.templatesCache.removeAll();
    }

    public void clearCssCache() {
        this.cssCache.removeAll();
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.clearTemplatesCache();
        this.clearCssCache();
    }
}

