/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.transaction;

import com.atlassian.jira.transaction.Transaction;
import com.atlassian.jira.transaction.TransactionRuntimeException;
import java.util.function.Supplier;

public interface TransactionSupport {
    public Transaction begin() throws TransactionRuntimeException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public <T> T execute(Supplier<T> callback) {
        Transaction t = this.begin();
        try {
            T callbackResponse = callback.get();
            t.commit();
            T t2 = callbackResponse;
            return t2;
        }
        finally {
            t.finallyRollbackIfNotCommitted();
        }
    }

    default public void execute(Runnable callback) {
        Transaction t = this.begin();
        try {
            callback.run();
            t.commit();
        }
        finally {
            t.finallyRollbackIfNotCommitted();
        }
    }
}

